/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.uda;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import de.bsvrz.buv.plugin.uda.internal.RahmenwerkService;
import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.dav.daf.main.MissingParameterException;
import de.bsvrz.ibv.uda.client.UdaClient;

/**
 * Basisklasse das Plugins.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 *
 */
public class UdaToolsPlugin extends AbstractUIPlugin {

	/** die ID des Plugins. */
	public static final String PLUGIN_ID = "de.bsvrz.buv.plugin.uda"; //$NON-NLS-1$

	/** die globale Instanz. */
	private static UdaToolsPlugin plugin;

	/** die Ressourcen des Plugins. */
	private ResourceBundle resourceBundle;

	/** Verbindung zum UDA-Client. */
	private UdaClient connector;

	/** Konstruktor. */
	public UdaToolsPlugin() {
		UdaToolsPlugin.plugin = this;
		try {
			resourceBundle = ResourceBundle.getBundle("de.bsvrz.buv.plugin.uda.UdaPluginResources"); //$NON-NLS-1$
		} catch (@SuppressWarnings("unused") final MissingResourceException x) {
			resourceBundle = null;
		}
	}

	/**
	 * liefert die globale Instanz.
	 *
	 * @return die Instanz.
	 */
	public static UdaToolsPlugin getDefault() {
		return UdaToolsPlugin.plugin;
	}

	/**
	 * liefert einen Imagedescriptor für den übergebenen Dateipfad.
	 *
	 * @param path
	 *            der Pfad.
	 * @return der Descriptor.
	 */
	public static ImageDescriptor getImageDescriptor(final String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin(UdaToolsPlugin.PLUGIN_ID, path);
	}

	/**
	 * Erfragt eine Verbindung zum UDA-Client.
	 *
	 * @return connector eine Verbindung zum UDA-Client.
	 * @throws MissingParameterException
	 *             wenn notwendige Verbindungsparameter nicht spezifiziert wurden.
	 */
	public UdaClient getConnector() throws MissingParameterException {
		if (connector == null) {
			final Rahmenwerk rahmenWerk = RahmenwerkService.getService().getRahmenWerk();
			connector = new UdaClient(rahmenWerk.getDavVerbindung(), rahmenWerk.getBenutzerName(),
					rahmenWerk.getPasswort(), null);
		}
		return connector;
	}

	/**
	 * ermittelt des Bundle mit den Plugin-Ressourcen.
	 *
	 * @return das Resource-Bundle.
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}

	@Override
	public void start(final BundleContext context) throws Exception {
		super.start(context);
		UdaToolsPlugin.plugin = this;
	}

	@Override
	public void stop(final BundleContext context) throws Exception {
		UdaToolsPlugin.plugin = null;
		super.stop(context);
	}

	/**
	 * Ausgabe einer Info-Meldung an den Error View.
	 *
	 * @param meldung
	 *            die Meldung
	 */
	public static void info(final String meldung) {
		UdaToolsPlugin.getDefault().getLog().log(new Status(IStatus.INFO, UdaToolsPlugin.PLUGIN_ID, meldung));
	}
}
