/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.uda.editor;

import java.util.ResourceBundle;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;

import de.bsvrz.buv.plugin.uda.UdaToolsPlugin;

/**
 * Die Konfiguration für die Anzeige des UDA-Skript-Textes.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 *
 */
public class UdaEditorContributor extends BasicTextEditorActionContributor {

	/**
	 * Vorschlagsaction.
	 */
	private final RetargetTextEditorAction contentAssistProposal;

	/**
	 * Vorschlagsaction.
	 */
	private final RetargetTextEditorAction contentAssistTip;

	/**
	 * Vorschlagsaction.
	 */
	private final RetargetTextEditorAction formatProposal;

	/**
	 * Constructor for SQLEditorContributor. Creates a new contributor in the form
	 * of adding Content Assist, Conent Format and Assist tip menu items
	 */
	public UdaEditorContributor() {
		super();
		final ResourceBundle bundle = UdaToolsPlugin.getDefault().getResourceBundle();

		contentAssistProposal = new RetargetTextEditorAction(bundle, "ContentAssistProposal."); //$NON-NLS-1$
		formatProposal = new RetargetTextEditorAction(bundle, "ContentFormatProposal."); //$NON-NLS-1$
		contentAssistTip = new RetargetTextEditorAction(bundle, "ContentAssistTip."); //$NON-NLS-1$
	}

	@Override
	public void contributeToMenu(final IMenuManager mm) {
		super.contributeToMenu(mm);
		final IMenuManager editMenu = mm.findMenuUsingPath(IWorkbenchActionConstants.M_EDIT);
		if (editMenu != null) {
			editMenu.add(new Separator());
			editMenu.add(contentAssistProposal);
			editMenu.add(formatProposal);
			editMenu.add(contentAssistTip);
		}
	}

	@Override
	public void contributeToToolBar(final IToolBarManager tbm) {
		super.contributeToToolBar(tbm);
		tbm.add(new Separator());
	}

	@Override
	public void setActiveEditor(final IEditorPart part) {

		super.setActiveEditor(part);

		ITextEditor editor = null;
		if (part instanceof ITextEditor) {
			editor = (ITextEditor) part;
		}

		contentAssistProposal.setAction(getAction(editor, "ContentAssistProposal")); //$NON-NLS-1$
		formatProposal.setAction(getAction(editor, "ContentFormatProposal")); //$NON-NLS-1$
		contentAssistTip.setAction(getAction(editor, "ContentAssistTip")); //$NON-NLS-1$

	}

}
