/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.uda.editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

import de.bsvrz.buv.plugin.uda.editor.text.UdaContentAssistProcessor;
import de.bsvrz.buv.plugin.uda.editor.text.UdaScanner;

/**
 * Die Konfiguration für die Anzeige des UDA-Skript-Textes.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 */
public class UdaEditorSourceViewerConfiguration extends SourceViewerConfiguration {

	/**
	 * der Scanner zur Analyse des Texts.
	 */
	private final UdaStyleProvider styleProvider;

	/**
	 * Konstruktor.
	 *
	 * @param styleProvider
	 *            Provider für Darstellungsoptionen
	 */
	public UdaEditorSourceViewerConfiguration(final UdaStyleProvider styleProvider) {
		this.styleProvider = styleProvider;
	}

	@Override
	public IContentAssistant getContentAssistant(final ISourceViewer sourceViewer) {
		final ContentAssistant assistant = new ContentAssistant();
		final IContentAssistProcessor processor = new UdaContentAssistProcessor();
		assistant.enableAutoActivation(true);
		assistant.setContentAssistProcessor(processor, IDocument.DEFAULT_CONTENT_TYPE);
		return assistant;
	}

	@Override
	public IPresentationReconciler getPresentationReconciler(final ISourceViewer sourceViewer) {

		final PresentationReconciler reconciler = new PresentationReconciler();

		DefaultDamagerRepairer dr = new DefaultDamagerRepairer(new UdaScanner(styleProvider));
		reconciler.setDamager(dr, IDocument.DEFAULT_CONTENT_TYPE);
		reconciler.setRepairer(dr, IDocument.DEFAULT_CONTENT_TYPE);

		dr = new DefaultDamagerRepairer(new UdaFixedScanner(UdaPartitionScanner.STRING, styleProvider));
		reconciler.setDamager(dr, UdaPartitionScanner.STRING);
		reconciler.setRepairer(dr, UdaPartitionScanner.STRING);

		dr = new DefaultDamagerRepairer(new UdaFixedScanner(UdaPartitionScanner.COMMENT, styleProvider));
		reconciler.setDamager(dr, UdaPartitionScanner.COMMENT);
		reconciler.setRepairer(dr, UdaPartitionScanner.COMMENT);

		return reconciler;

	}
}
