/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.uda.editor;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;

/**
 * Syntax-Scanner-Konfiguration.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 *
 */
public class UdaFixedScanner extends RuleBasedScanner {

	/**
	 * Dummyregel.
	 *
	 * @author BitCtrl Systems GmbH, Uwe Peuker
	 *
	 *
	 */
	public static class DummyRule implements IRule {

		/**
		 * Token.
		 */
		private final IToken token;

		/**
		 * Standardkonstruktor.
		 *
		 * @param token
		 *            ein Token.
		 */
		public DummyRule(final IToken token) {
			this.token = token;
		}

		@Override
		public IToken evaluate(final ICharacterScanner scanner) {
			final int c = scanner.read();
			if (c == ICharacterScanner.EOF) {
				return Token.EOF;
			}
			return token;
		}

	}

	/**
	 * Standardkonstruktor.
	 *
	 * @param token
	 *            ein Token.
	 * @param styleProvider
	 *            der Style-Provider der auf dieses Token angewendet werden soll.
	 */
	public UdaFixedScanner(final String token, final UdaStyleProvider styleProvider) {
		super();
		final IRule[] rules = { new DummyRule(styleProvider.getToken(token)) };
		setRules(rules);
	}

}
