/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.uda.editor.text;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

/**
 * Prozessor zum Berechnen der Textkomplettierungen.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 */
public class UdaContentAssistProcessor implements IContentAssistProcessor {

	@Override
	public ICompletionProposal[] computeCompletionProposals(final ITextViewer viewer, final int offset) {
		final Collection<ICompletionProposal> proposals = new ArrayList<>();

		final IDocument document = viewer.getDocument();
		final String prefix = getPrefixAt(document, offset);
		if (prefix.length() > 0) {
			for (final String word : UdaScanner.UDA_KEYWORDS) {
				if (word.startsWith(prefix)) {
					proposals.add(
							new CompletionProposal(word, offset - prefix.length(), prefix.length(), word.length()));
				}
			}
		}

		return proposals.toArray(new ICompletionProposal[proposals.size()]);
	}

	@Override
	public IContextInformation[] computeContextInformation(final ITextViewer viewer, final int offset) {
		return null;
	}

	@Override
	public char[] getCompletionProposalAutoActivationCharacters() {
		return new char[] { '.' };
	}

	@Override
	public char[] getContextInformationAutoActivationCharacters() {
		return null;
	}

	@Override
	public IContextInformationValidator getContextInformationValidator() {
		return null;
	}

	@Override
	public String getErrorMessage() {
		return null;
	}

	/**
	 * Liefert den Prefix an einer Stelle des Dokuments.
	 *
	 * @param document
	 *            das Dokument.
	 * @param offset
	 *            der Offset.
	 * @return der Prefix.
	 */
	private String getPrefixAt(final IDocument document, final int offset) {
		int idx = offset - 1;
		final StringBuffer buffer = new StringBuffer();
		try {
			char c = document.getChar(idx--);
			while (!Character.isWhitespace(c)) {
				buffer.insert(0, c);
				c = document.getChar(idx--);
			}
		} catch (final BadLocationException e) {
			e.printStackTrace();
		}

		return buffer.toString();
	}

}
