/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.uda.editor.text;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

import de.bsvrz.buv.plugin.uda.editor.UdaPartitionScanner;
import de.bsvrz.buv.plugin.uda.editor.UdaStyleProvider;

/**
 * Der Scanner zur Analyse des UDA-Skript-Textes.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 *
 */
public class UdaScanner extends RuleBasedScanner {

	/** ANTLR keywords die ge"highlighted" werden. */
	static final String[] UDA_KEYWORDS = new String[] { "aktuell", "aktualisierung", "alle", "als", "anmeldung",
			"ausgabe", "ausnahme", "bedingung", "benutze", "bei", "bis", "dann", "debug", "definition", "dem", "den",
			"der", "die", "div", "ein", "eine", "einen", "elemente", "empfaenger", "empfänger", "ende", "erfuellt",
			"erfüllt", "falsch", "fehlerausgabe", "fehlerBehandlung", "fehlerpruefung", "fehlerprüfung",
			"fehlerrueckgabe", "fehlerrückgabe", "fuer", "für", "funktion", "gilt", "gruppe", "hoechstens", "höchstens",
			"in", "initial", "ist", "iteration", "jede", "jeden", "jedes", "jeweils", "menge", "mengenAenderung",
			"mengenÄnderung", "Millisekunden", "Millisekunde", "mindestens", "Minuten", "Minute", "mit", "modulo",
			"nicht", "oder", "ohne", "quantor", "quelle", "rueckgabe", "rückgabe", "schrittweite", "Sekunden",
			"Sekunde", "sender", "senke", "solange", "sonst", "Stunden", "Stunde", "Tage", "Tag", "timer", "ueber",
			"über", "und", "undefiniert", "von", "versuche", "wahr", "wenn", "zeile", "zyklisch" };

	/**
	 * Create an instance of a code scanner for syntax highlighting.
	 *
	 * @param styleProvider
	 *            der Styleprovider.
	 */
	public UdaScanner(final UdaStyleProvider styleProvider) {

		final IToken keyword = styleProvider.getToken(UdaPartitionScanner.KEYWORD);
		final IToken other = styleProvider.getToken(IDocument.DEFAULT_CONTENT_TYPE);
		final List<IRule> rules = new ArrayList<>();

		// Add generic whitespace rule
		rules.add(new WhitespaceRule(new UdaWhitespaceDetector()));
		// Add word rule for ANTLR keywords
		final WordRule wordRule = new WordRule(UdaWordDetector.getInstance(), other);
		for (final String element : UdaScanner.UDA_KEYWORDS) {
			wordRule.addWord(element, keyword);
		}
		rules.add(wordRule);

		final IRule[] result = new IRule[rules.size()];
		rules.toArray(result);
		setRules(result);
	}
}
