/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.uda.handler;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.ibv.uda.client.ClientSkriptLauf;

/**
 * Handler für das Kommando zum Entfernen eines Skriptlaufs.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 *
 */
public class RemoveSkriptLaufHandler extends UdaHandler {

	@Override
	public Object execute(final ExecutionEvent event) throws ExecutionException {

		final ClientSkriptLauf skriptLauf = getSkriptLauf(event);

		if (skriptLauf != null) {

			final String name = "Skriptlauf: " + skriptLauf.getName();

			if (MessageDialog.openQuestion(Display.getDefault().getActiveShell(), "Löschen",
					"Soll das Element: " + System.getProperty("line.separator") + name
							+ System.getProperty("line.separator") + "wirklich gelöscht werden ?")) {
				try {
					skriptLauf.getModul().removeLauf(skriptLauf);

				} catch (final ConfigurationChangeException e) {
					MessageDialog.openError(Display.getDefault().getActiveShell(), "FEHLER",
							"Fehler beim Entfernen eines Skriptlaufs: " + e.getMessage());
				}
			}
		}
		return null;
	}
}
