/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.uda.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

import de.bsvrz.ibv.uda.client.ClientModul;
import de.bsvrz.ibv.uda.client.ClientSkript;
import de.bsvrz.ibv.uda.client.ClientSkriptLauf;

/**
 * Abstrakter Handler, der Skripte oder Skriptläufe behandelt.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 */
public abstract class UdaHandler extends AbstractHandler {

	protected ClientSkript getSkript(final ExecutionEvent event) {

		final ISelection selection = HandlerUtil.getCurrentSelection(event);
		if (selection instanceof IStructuredSelection) {
			final Object skript = ((IStructuredSelection) selection).getFirstElement();
			if (skript instanceof ClientSkript) {
				return (ClientSkript) skript;
			}
		}

		return null;
	}

	protected ClientSkriptLauf getSkriptLauf(final ExecutionEvent event) {

		final ISelection selection = HandlerUtil.getCurrentSelection(event);
		if (selection instanceof IStructuredSelection) {
			final Object skriptlauf = ((IStructuredSelection) selection).getFirstElement();
			if (skriptlauf instanceof ClientSkriptLauf) {
				return (ClientSkriptLauf) skriptlauf;
			}
		}

		return null;
	}

	protected ClientModul getModul(final ExecutionEvent event) {

		final ISelection selection = HandlerUtil.getCurrentSelection(event);
		if (selection instanceof IStructuredSelection) {
			final Object object = ((IStructuredSelection) selection).getFirstElement();
			if (object instanceof ClientModul) {
				return (ClientModul) object;
			}
			if (object instanceof ClientSkript) {
				return ((ClientSkript) object).getModul();
			}
			if (object instanceof ClientSkriptLauf) {
				return ((ClientSkriptLauf) object).getModul();
			}
		}

		return null;
	}

}
