/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.uda.navigator;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;

import de.bsvrz.buv.plugin.uda.wizards.SkriptSaveWizard;
import de.bsvrz.ibv.uda.client.ClientSkript;

/**
 * Adapterklasse zum Zugriff auf ein UDA-Skript.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 *
 */
public class UdaSkriptAdapter implements IStorageEditorInput {

	/** das Skript. */
	private final ClientSkript skript;

	/**
	 * Konstruktor.
	 *
	 * @param skript
	 *            das Skript
	 */
	public UdaSkriptAdapter(final ClientSkript skript) {
		this.skript = skript;
	}

	/**
	 * speichert das übergebene Dokument.
	 *
	 * @param document
	 *            das Dokument.
	 */
	public void doSave(final IDocument document) {
		final SkriptSaveWizard wizard = new SkriptSaveWizard(skript, document);
		final WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), wizard);
		dialog.open();
	}

	@Override
	public boolean exists() {
		// TODO Automatisch erstellter Methoden-Stub
		return false;
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@Override
	public Object getAdapter(final Class adapter) {
		return null;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return null;
	}

	@Override
	public String getName() {
		return skript.getName();
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	/**
	 * liefert das zugeordnete Skript.
	 *
	 * @return das Skript.
	 */
	public ClientSkript getSkript() {
		return skript;
	}

	@Override
	public IStorage getStorage() throws CoreException {
		return new UdaFileStorage(skript);
	}

	@Override
	public String getToolTipText() {
		return getName();
	}

	@Override
	public String toString() {
		return skript.getName();
	}
}
