/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.uda.wizards;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.ibv.uda.client.ClientException;
import de.bsvrz.ibv.uda.client.ClientModul;
import de.bsvrz.ibv.uda.client.SkriptLaufDaten;

/**
 * Wizard zum Anlegen eines Skriptlaufes.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 *
 */
public class CreateSkriptLaufWizard extends Wizard {

	/** die Datenseite zur Anzeige der Skriptlaufinformationen. */
	private SkriptLaufDataPage dataPage;

	/** das verwendete UDA-Modul. */
	private final ClientModul udaModul;

	/**
	 * Konstruktor.
	 *
	 * @param udaModul
	 *            das verwendete UDA-Modul
	 */
	public CreateSkriptLaufWizard(final ClientModul udaModul) {
		this.udaModul = udaModul;
	}

	@Override
	public void addPages() {
		super.addPages();
		dataPage = new SkriptLaufDataPage(udaModul, null);
		addPage(dataPage);
	}

	@Override
	public boolean performFinish() {
		boolean result = false;
		final String benutzer = dataPage.getEditBenutzerName();
		if ((benutzer != null) && (benutzer.length() > 0)) {
			try {
				final SkriptLaufDaten daten = dataPage.getSkriptLauf();
				udaModul.erzeugeSkriptLauf(daten, benutzer, dataPage.getGrund());
				result = true;
			} catch (final ClientException e) {
				MessageDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "FEHLER",
						e.getMessage());
			}
		} else {
			MessageDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "FEHLER",
					"Der Name des ändernden Nutzers muss eingetragen werden");
		}
		return result;
	}
}
