/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.uda.wizards;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.ibv.uda.client.ClientException;
import de.bsvrz.ibv.uda.client.ClientSkript;

/**
 * Wizard zum Bearbeiten der Daten eines UDA-Skripts.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 *
 */
public class EditSkriptWizard extends Wizard {

	/** die Datenseite zur Anzeige der Skriptdaten. */
	private SkriptDataPage dataPage;

	/** das editierte Skript. */
	private final ClientSkript skript;

	/**
	 * Konstruktor.
	 *
	 * @param skript
	 *            das Skript, das bearbeitet werden soll
	 */
	public EditSkriptWizard(final ClientSkript skript) {
		this.skript = skript;
	}

	@Override
	public void addPages() {
		super.addPages();
		dataPage = new SkriptDataPage(skript);
		addPage(dataPage);
	}

	@Override
	public boolean performFinish() {
		boolean result = false;
		final SkriptDaten daten = dataPage.getSkriptDaten();
		if (!daten.getName().isEmpty()) {
			try {
				skript.kopiereDaten(daten);
				skript.save(dataPage.getBenutzer(), dataPage.getGrund());
				result = true;
			} catch (final ClientException e) {
				MessageDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "FEHLER",
						e.getMessage());
			}
		}
		return result;
	}
}
