/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.uda.wizards;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import de.bsvrz.ibv.uda.uda.data.Skript;
import de.bsvrz.ibv.uda.uda.data.SkriptZustand;

/**
 * Wizzard zum Abspeichern des Skript-Textes.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 *
 */
public class SkriptSavePage extends WizardPage {

	/** Das Skript. */
	private final Skript skript;

	/** Feld fuer den Nutzernamen. */
	private Text userField;

	/** Feld fuer den Speichergrund. */
	private Text reasonField;

	/** Der Zustandsselektor. */
	private ComboViewer zustandsSelector;

	/**
	 * Standardkonstruktor.
	 *
	 * @param skript
	 *            das Skript.
	 */
	protected SkriptSavePage(final Skript skript) {
		super("Skript sichern bzw. Status ändern");
		this.skript = skript;
		setTitle("Skript sichern bzw. Status ändern");
		setMessage("Geben Sie hier die Informationen zum Speichern des Skripts an");
	}

	@Override
	public void createControl(final Composite parent) {
		final GridLayout pageLayout = new GridLayout();
		pageLayout.numColumns = 2;
		parent.setLayout(pageLayout);
		parent.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		Label label = new Label(parent, SWT.NONE);
		label.setText("Benutzer: ");
		userField = new Text(parent, SWT.BORDER);
		userField.setLayoutData(new GridData(GridData.FILL_BOTH | GridData.GRAB_HORIZONTAL));

		label = new Label(parent, SWT.NONE);
		label.setText("Grund: ");
		reasonField = new Text(parent, SWT.BORDER);
		reasonField.setLayoutData(new GridData(GridData.FILL_BOTH | GridData.GRAB_HORIZONTAL));

		label = new Label(parent, SWT.NONE);
		label.setText("Zustand: ");
		zustandsSelector = new ComboViewer(parent, SWT.NONE);
		zustandsSelector.setContentProvider(new UdaSkriptZustandsProvider());
		zustandsSelector.setInput(this);
		zustandsSelector.setSelection(new StructuredSelection(skript.getZustand()));
		zustandsSelector.getCombo().setLayoutData(new GridData(GridData.FILL_BOTH | GridData.GRAB_HORIZONTAL));

		setControl(parent);
	}

	/**
	 * Erfragt den Benutzer.
	 *
	 * @return der Benutzer.
	 */
	public String getBenutzer() {
		return userField.getText();
	}

	/**
	 * Erfragt den Speichergrund.
	 *
	 * @return der Speichergrund.
	 */
	public String getGrund() {
		return reasonField.getText();
	}

	/**
	 * Erfragt den Zustand des Skriptes.
	 *
	 * @return der Zustand des Skriptes.
	 */
	public SkriptZustand getZustand() {
		return (SkriptZustand) ((IStructuredSelection) zustandsSelector.getSelection()).getFirstElement();
	}
}
