/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.uda.wizards;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.wizard.Wizard;

import de.bsvrz.ibv.uda.client.ClientException;
import de.bsvrz.ibv.uda.client.ClientSkript;

/**
 * Wizzard zum Abspeichern des Skript-Textes.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 *
 */
public class SkriptSaveWizard extends Wizard {

	/**
	 * Dok.
	 */
	private final IDocument document;

	/**
	 * UDA-Skript.
	 */
	private final ClientSkript skript;

	/**
	 * Assoziierte Datenseite.
	 */
	private SkriptSavePage dataPage;

	/**
	 * Konstruktor.
	 *
	 * @param skript
	 *            das Skript
	 * @param document
	 *            das Dokument, das gesichert werden soll
	 */
	public SkriptSaveWizard(final ClientSkript skript, final IDocument document) {
		this.skript = skript;
		this.document = document;
	}

	@Override
	public void addPages() {
		super.addPages();
		dataPage = new SkriptSavePage(skript);
		addPage(dataPage);
	}

	@Override
	public boolean performFinish() {
		final BufferedReader reader = new BufferedReader(new StringReader(document.get()));
		String line = null;
		boolean result = false;
		try {
			skript.clearSourceCode();
			while ((line = reader.readLine()) != null) {
				skript.addSourceLine(line);
			}
			skript.setZustand(dataPage.getZustand());
			skript.save(dataPage.getBenutzer(), dataPage.getGrund());
			result = true;
		} catch (final IOException e) {
			e.printStackTrace();
		} catch (final ClientException e) {
			e.printStackTrace();
		}

		return result;
	}

}
