/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.uda.builder;

import de.bsvrz.buv.plugin.uda.UdaToolsPlugin;
import de.bsvrz.dav.daf.main.MissingParameterException;
import de.bsvrz.ibv.uda.client.LokalesSkript;
import de.bsvrz.ibv.uda.client.SkriptLaufDaten;
import de.bsvrz.ibv.uda.interpreter.UdaInterpreter;
import de.bsvrz.ibv.uda.interpreter.UdaInterpreterException;
import de.bsvrz.ibv.uda.interpreter.UdaParserFehler;
import de.bsvrz.ibv.uda.uda.data.Skript;
import de.bsvrz.ibv.uda.uda.data.SkriptLauf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class UdaBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = UdaBuilder.class.getName();

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IResourceDelta[] iResourceDeltaArray = this.getDelta(this.getProject()).getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta delta = iResourceDeltaArray[n2];
            Collection<IFile> files = this.getFiles(delta, "uda");
            for (IFile file : files) {
                this.compileSkript(file, monitor);
            }
            ++n2;
        }
        return null;
    }

    public void compileSkript(IFile udaFile, IProgressMonitor monitor) throws CoreException {
        IMarker[] problems;
        Collection fehlerListe = null;
        IMarker[] iMarkerArray = problems = udaFile.findMarkers("org.eclipse.core.resources.problemmarker", true, 1);
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            marker.delete();
            ++n2;
        }
        try {
            SkriptLaufDaten lauf = new SkriptLaufDaten(null, "CompilerLauf", (Skript)new LokalesSkript(udaFile.getLocation().toFile().getAbsolutePath()));
            new UdaInterpreter(UdaToolsPlugin.getDefault().getConnector().getVerbindung(), (SkriptLauf)lauf);
        }
        catch (UdaInterpreterException e) {
            fehlerListe = e.getFehlerListe();
        }
        catch (MissingParameterException e) {
            e.printStackTrace();
        }
        if (fehlerListe != null) {
            for (UdaParserFehler fehler : fehlerListe) {
                IMarker marker = udaFile.createMarker("org.eclipse.core.resources.problemmarker");
                marker.setAttribute("severity", 2);
                marker.setAttribute("message", (Object)fehler.getMessage());
                marker.setAttribute("location", (Object)("Zeile " + fehler.getLine()));
                marker.setAttribute("lineNumber", fehler.getLine());
            }
        }
    }

    private Collection<IFile> getFiles(IResourceDelta item, String string) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        IResource resource = item.getResource();
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            if (string.equals(file.getFileExtension())) {
                result.add(file);
            }
        } else {
            IResourceDelta[] delta;
            IResourceDelta[] iResourceDeltaArray = delta = item.getAffectedChildren();
            int n = delta.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta deltaItem = iResourceDeltaArray[n2];
                result.addAll(this.getFiles(deltaItem, string));
                ++n2;
            }
        }
        return result;
    }
}

