/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.uda.editor.text;

import de.bsvrz.buv.plugin.uda.editor.text.UdaScanner;
import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class UdaContentAssistProcessor
implements IContentAssistProcessor {
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        IDocument document = viewer.getDocument();
        String prefix = this.getPrefixAt(document, offset);
        if (prefix.length() > 0) {
            String[] stringArray = UdaScanner.UDA_KEYWORDS;
            int n = UdaScanner.UDA_KEYWORDS.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                if (word.startsWith(prefix)) {
                    proposals.add(new CompletionProposal(word, offset - prefix.length(), prefix.length(), word.length()));
                }
                ++n2;
            }
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    private String getPrefixAt(IDocument document, int offset) {
        int idx = offset - 1;
        StringBuffer buffer = new StringBuffer();
        try {
            char c = document.getChar(idx--);
            while (!Character.isWhitespace(c)) {
                buffer.insert(0, c);
                c = document.getChar(idx--);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }
}

