/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.uda.handler;

import de.bsvrz.buv.plugin.uda.UdaToolsPlugin;
import de.bsvrz.buv.plugin.uda.handler.UdaHandler;
import de.bsvrz.dav.daf.main.MissingParameterException;
import de.bsvrz.ibv.uda.client.ClientSkript;
import de.bsvrz.ibv.uda.client.ParserResult;
import de.bsvrz.ibv.uda.interpreter.UdaParserFehler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SkriptParsenHandler
extends UdaHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ClientSkript skript = this.getSkript(event);
        if (skript != null) {
            try {
                File file = File.createTempFile("skriptparser", ".tmp");
                file.deleteOnExit();
                Throwable throwable = null;
                Object var5_8 = null;
                try (FileWriter writer = new FileWriter(file);){
                    for (String line : skript.getSourceCode()) {
                        writer.write(line);
                        writer.write(System.getProperty("line.separator"));
                    }
                    writer.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ParserResult result = UdaToolsPlugin.getDefault().getConnector().parseSkriptText(file.getAbsolutePath());
                if (!file.delete()) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Fehler", (String)("Tempor\u00e4re Datei " + file.getAbsolutePath() + " konnte nicht gel\u00f6scht werden"));
                }
                if (result.isParsed()) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Pr\u00fcfung", (String)"Pr\u00fcfung des Skripts erfolgreich durchgef\u00fchrt");
                } else {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("Skript enth\u00e4lt Fehler:");
                    buffer.append(System.getProperty("line.separator"));
                    buffer.append("=======================");
                    for (UdaParserFehler fehler : result.getFehlerListe()) {
                        buffer.append(System.getProperty("line.separator"));
                        buffer.append(String.valueOf(fehler.getLine()) + ": " + fehler.getMessage());
                    }
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Pr\u00fcfung", (String)buffer.toString());
                }
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Fehler", (String)("Pr\u00fcfung des Skripts fehlgeschlagen: " + System.getProperty("line.separator") + e.getMessage()));
            }
            catch (MissingParameterException e) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Fehler", (String)("Pr\u00fcfung des Skripts fehlgeschlagen: " + System.getProperty("line.separator") + e.getMessage()));
            }
        }
        return null;
    }
}

