/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.uda.navigator;

import de.bsvrz.buv.plugin.uda.UdaToolsPlugin;
import de.bsvrz.buv.plugin.uda.handler.EditSkriptTextHandler;
import de.bsvrz.buv.plugin.uda.handler.SkriptLaufStartenHandler;
import de.bsvrz.buv.plugin.uda.handler.SkriptLaufViewHandler;
import de.bsvrz.buv.plugin.uda.navigator.UdaModulNavigatorContentProvider;
import de.bsvrz.buv.plugin.uda.navigator.UdaModulNavigatorLabelProvider;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.MissingParameterException;
import de.bsvrz.ibv.uda.client.ClientModul;
import de.bsvrz.ibv.uda.client.ClientSkript;
import de.bsvrz.ibv.uda.client.ClientSkriptLauf;
import de.bsvrz.ibv.uda.client.ModulListener;
import de.bsvrz.ibv.uda.client.SkriptLaufListener;
import de.bsvrz.ibv.uda.client.SkriptListener;
import de.bsvrz.ibv.uda.client.UdaClient;
import de.bsvrz.ibv.uda.client.UdaConnectionListener;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class UdaModulNavigator
extends ViewPart
implements UdaConnectionListener,
ModulListener,
SkriptListener,
SkriptLaufListener,
IDoubleClickListener {
    public static final String ID = UdaModulNavigator.class.getName();
    private static final String HILFE_ID = "de.bsvrz.buv.plugin.uda." + UdaModulNavigator.class.getSimpleName();
    private TreeViewer navigatorTree;
    private UdaClient connector;

    private void abmelden(ClientModul client) {
        client.removeClientListener((ModulListener)this);
        client.removeSkriptListener((SkriptListener)this);
        client.removeLaufListener((SkriptLaufListener)this);
    }

    public void connected() {
        this.initialisiereDaten();
        this.refreshTree();
    }

    public void connectionClosed(ClientDavInterface connection) {
        this.initialisiereDaten();
        this.refreshTree();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)new Separator("additions"));
        this.navigatorTree.getControl().setMenu(menuManager.createContextMenu(this.navigatorTree.getControl()));
        this.getSite().registerContextMenu(String.valueOf(ID) + ".contextMenu", menuManager, (ISelectionProvider)this.navigatorTree);
    }

    public void createPartControl(Composite parent1) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        Composite basisComposite = new Composite(parent1, 0);
        basisComposite.setLayout((Layout)gridLayout);
        try {
            this.connector = UdaToolsPlugin.getDefault().getConnector();
        }
        catch (MissingParameterException e) {
            e.printStackTrace();
        }
        this.connector.addConnectionListener((UdaConnectionListener)this);
        this.initialisiereDaten();
        this.navigatorTree = new TreeViewer(basisComposite, 0);
        GridData gridData1 = new GridData();
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.verticalAlignment = 4;
        gridData1.grabExcessVerticalSpace = true;
        gridData1.horizontalAlignment = 4;
        this.navigatorTree.getTree().setLayoutData((Object)gridData1);
        this.navigatorTree.setContentProvider((IContentProvider)new UdaModulNavigatorContentProvider(this));
        this.navigatorTree.setLabelProvider((IBaseLabelProvider)new UdaModulNavigatorLabelProvider());
        this.navigatorTree.setComparator(new ViewerComparator());
        this.navigatorTree.addDoubleClickListener((IDoubleClickListener)this);
        this.navigatorTree.setInput((Object)this);
        this.createContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.navigatorTree);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)basisComposite, HILFE_ID);
    }

    public void dispose() {
        for (ClientModul client : this.connector.getModule()) {
            this.abmelden(client);
        }
        this.connector.removeConnectionListener((UdaConnectionListener)this);
        super.dispose();
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection selektion = (IStructuredSelection)event.getSelection();
        if (selektion != null) {
            Object selektiertesObjekt = selektion.getFirstElement();
            if (selektiertesObjekt == null) {
                return;
            }
            if (selektiertesObjekt instanceof ClientSkript) {
                new EditSkriptTextHandler().edit((ClientSkript)selektiertesObjekt);
            } else if (selektiertesObjekt instanceof ClientSkriptLauf) {
                new SkriptLaufViewHandler().openView((ClientSkriptLauf)selektiertesObjekt);
                new SkriptLaufStartenHandler().startSkriptLauf((ClientSkriptLauf)selektiertesObjekt);
            }
        }
    }

    public void ergebnisAktualisiert(ClientSkriptLauf lauf) {
    }

    public UdaClient getConnector() {
        return this.connector;
    }

    private void initialisiereDaten() {
        if (this.connector.isConnected()) {
            for (ClientModul modul : this.connector.getModule()) {
                modul.addClientListener((ModulListener)this);
                modul.addSkriptListener((SkriptListener)this);
                modul.addLaufListener((SkriptLaufListener)this);
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    UdaModulNavigator.this.refreshTree();
                }
            });
        }
    }

    public void meldungsListeAktualisiert(ClientSkriptLauf skript) {
    }

    public void neuerModulStatus(ClientModul modul, boolean valid) {
        this.refreshTree();
    }

    void refreshTree() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                UdaModulNavigator.this.navigatorTree.refresh(true);
            }
        });
    }

    public void skriptAktualisiert(ClientSkript skript) {
        this.refreshTree();
    }

    public void skriptAktualisiert(ClientSkriptLauf skript) {
        this.refreshTree();
    }

    public void skriptAngelegt(ClientModul client, ClientSkript skript) {
        this.refreshTree();
    }

    public void skriptEntfernt(ClientModul modul, ClientSkript skript) {
        this.refreshTree();
    }

    public void skriptLaufAngelegt(ClientModul modul, ClientSkriptLauf lauf) {
        this.refreshTree();
    }

    public void skriptLaufEntfernt(ClientModul modul, ClientSkriptLauf lauf) {
        this.refreshTree();
    }

    public void skriptZustandAktualisiert(ClientSkriptLauf skript) {
        this.refreshTree();
    }

    public void setFocus() {
        if (this.navigatorTree != null && !this.navigatorTree.getControl().isDisposed()) {
            this.navigatorTree.getControl().setFocus();
        }
    }
}

