/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.uda.views;

import de.bsvrz.buv.plugin.uda.UdaToolsPlugin;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.MissingParameterException;
import de.bsvrz.ibv.uda.client.ClientModul;
import de.bsvrz.ibv.uda.client.ClientSkriptLauf;
import de.bsvrz.ibv.uda.client.SkriptLaufListener;
import de.bsvrz.ibv.uda.client.UdaConnectionListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class LaufLogSicht
extends ViewPart
implements UdaConnectionListener,
SkriptLaufListener {
    public static final String ID = LaufLogSicht.class.getName();
    private static final String HILFE_ID = "de.bsvrz.buv.plugin.uda." + LaufLogSicht.class.getSimpleName();
    private String modulPid;
    private ClientSkriptLauf loggedLauf;
    private ListViewer viewer;
    private final List<String> meldungen = new ArrayList<String>();

    public LaufLogSicht() {
        try {
            UdaToolsPlugin.getDefault().getConnector().addConnectionListener((UdaConnectionListener)this);
        }
        catch (MissingParameterException e) {
            e.printStackTrace();
        }
    }

    public void connected() {
        block4: {
            try {
                if (this.loggedLauf == null || this.modulPid == null) break block4;
                for (ClientModul modul : UdaToolsPlugin.getDefault().getConnector().getModule()) {
                    if (!modul.getModulObjekt().getPid().equals(this.modulPid)) continue;
                    for (ClientSkriptLauf skriptLauf : modul.getSkriptLaeufe()) {
                        if (!skriptLauf.getDavObjekt().getPid().equals(this.loggedLauf.getDavObjekt().getPid())) continue;
                        this.setLauf(skriptLauf);
                        break block4;
                    }
                    break;
                }
            }
            catch (MissingParameterException e) {
                e.printStackTrace();
            }
        }
    }

    public void connectionClosed(ClientDavInterface connection) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                LaufLogSicht.this.viewer.getList().removeAll();
            }
        });
    }

    public void createPartControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)gridLayout);
        this.viewer = new ListViewer(composite, 2816);
        GridData gridData1 = new GridData();
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.verticalAlignment = 4;
        gridData1.grabExcessVerticalSpace = true;
        gridData1.horizontalAlignment = 4;
        this.viewer.getList().setLayoutData((Object)gridData1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HILFE_ID);
    }

    public void dispose() {
        if (this.loggedLauf != null) {
            this.loggedLauf.getModul().removeLaufListener((SkriptLaufListener)this);
        }
        super.dispose();
    }

    public void ergebnisAktualisiert(ClientSkriptLauf lauf) {
    }

    public void meldungsListeAktualisiert(ClientSkriptLauf skript) {
        if (this.loggedLauf.equals(skript)) {
            this.meldungen.clear();
            for (String line : this.loggedLauf.getMeldungen()) {
                this.meldungen.add(0, line);
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LaufLogSicht.this.updateViewer();
                }
            });
        }
    }

    public void setLauf(ClientSkriptLauf lauf) {
        if (lauf != null) {
            this.setPartName(lauf.getName());
            lauf.getModul().addLaufListener((SkriptLaufListener)this);
            this.modulPid = lauf.getModul().getModulObjekt().getPid();
        } else {
            this.modulPid = null;
        }
        this.loggedLauf = lauf;
    }

    public void skriptAktualisiert(ClientSkriptLauf skript) {
    }

    public void skriptZustandAktualisiert(ClientSkriptLauf skript) {
    }

    void updateViewer() {
        this.viewer.getList().removeAll();
        for (String line : this.meldungen) {
            this.viewer.getList().add(line);
        }
    }

    public void setFocus() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }
}

