/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.uda.views;

import de.bsvrz.ibv.uda.client.ClientModul;
import de.bsvrz.ibv.uda.client.ClientSkriptLauf;
import de.bsvrz.ibv.uda.client.UdaClient;
import de.bsvrz.ibv.uda.uda.data.Modul;
import de.bsvrz.ibv.uda.uda.data.SkriptLaufStatus;
import de.bsvrz.ibv.uda.uda.data.SkriptZustand;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class SkriptLaufOverViewProvider
extends LabelProvider
implements IStructuredContentProvider,
ITableLabelProvider,
ITableColorProvider {
    private static final Color WHITE = Display.getDefault().getSystemColor(1);
    private static final Color RED = Display.getDefault().getSystemColor(3);
    private static final Color BLUE = Display.getDefault().getSystemColor(9);
    private static final Color GRAY = Display.getDefault().getSystemColor(15);
    private static final Color BLACK = Display.getDefault().getSystemColor(2);
    private static final Color DARK_GREEN = Display.getDefault().getSystemColor(6);
    private static final String[] COLUMN_NAMES = new String[]{"Modul", "Skriptlauf", "Skript", "Status", "Zeit", "Ergebnis"};

    public void dispose() {
    }

    public Color getBackground(Object element, int columnIndex) {
        return WHITE;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    String[] getColumnNames() {
        return COLUMN_NAMES;
    }

    public String getColumnText(Object element, int columnIndex) {
        String result = null;
        if (element instanceof ClientSkriptLauf) {
            ClientSkriptLauf lauf = (ClientSkriptLauf)element;
            switch (columnIndex) {
                case 0: {
                    if (lauf.getModul() == null) break;
                    result = lauf.getModul().getModulObjekt().getNameOrPidOrId();
                    break;
                }
                case 1: {
                    result = lauf.getName();
                    break;
                }
                case 2: {
                    if (lauf.getSkript() == null) break;
                    result = lauf.getSkript().getName();
                    break;
                }
                case 3: {
                    result = lauf.getStatus().toString();
                    break;
                }
                case 4: {
                    if (lauf.getLaufErgebnis() == null) break;
                    result = lauf.getLaufErgebnis().getZeitString();
                    break;
                }
                case 5: {
                    if (lauf.getLaufErgebnis() == null) break;
                    result = lauf.getLaufErgebnis().getText(0);
                    break;
                }
                default: {
                    result = "";
                }
            }
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public Object[] getElements(Object element) {
        ArrayList elements = new ArrayList();
        if (element instanceof UdaClient) {
            for (Modul modul : ((UdaClient)element).getModule()) {
                if (!(modul instanceof ClientModul)) continue;
                elements.addAll(((ClientModul)modul).getSkriptLaeufe());
            }
        }
        return elements.toArray();
    }

    public Color getForeground(Object element, int columnIndex) {
        Color result = BLACK;
        if (element instanceof ClientSkriptLauf) {
            ClientSkriptLauf lauf = (ClientSkriptLauf)element;
            result = lauf.getSkript() == null || !SkriptZustand.FREIGEGEBEN.equals((Object)lauf.getSkript().getZustand()) ? GRAY : (SkriptLaufStatus.AKTIV.equals((Object)lauf.getStatus()) ? DARK_GREEN : (lauf.getLaufErgebnis() != null && !lauf.getLaufErgebnis().isOk() ? RED : BLUE));
        }
        return result;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

