/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.uda.views;

import de.bsvrz.buv.plugin.uda.UdaToolsPlugin;
import de.bsvrz.buv.plugin.uda.views.SkriptLaufOverViewProvider;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.MissingParameterException;
import de.bsvrz.ibv.uda.client.ClientModul;
import de.bsvrz.ibv.uda.client.ClientSkript;
import de.bsvrz.ibv.uda.client.ClientSkriptLauf;
import de.bsvrz.ibv.uda.client.ModulListener;
import de.bsvrz.ibv.uda.client.SkriptLaufListener;
import de.bsvrz.ibv.uda.client.SkriptListener;
import de.bsvrz.ibv.uda.client.UdaClient;
import de.bsvrz.ibv.uda.client.UdaConnectionListener;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class SkriptLaufUebersicht
extends ViewPart
implements UdaConnectionListener,
ModulListener,
SkriptLaufListener,
SkriptListener {
    public static final String ID = SkriptLaufUebersicht.class.getName();
    private static final String HILFE_ID = "de.bsvrz.buv.plugin.uda." + SkriptLaufUebersicht.class.getSimpleName();
    private TableViewer viewer;
    private UdaClient client;

    public SkriptLaufUebersicht() {
        try {
            UdaToolsPlugin.getDefault().getConnector().addConnectionListener((UdaConnectionListener)this);
        }
        catch (MissingParameterException e) {
            e.printStackTrace();
        }
    }

    private void aktualisieren() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!SkriptLaufUebersicht.this.viewer.getControl().isDisposed()) {
                    SkriptLaufUebersicht.this.viewer.refresh();
                }
            }
        });
    }

    public void connected() {
        for (ClientModul modul : this.client.getModule()) {
            modul.addClientListener((ModulListener)this);
            modul.addLaufListener((SkriptLaufListener)this);
        }
        this.aktualisieren();
    }

    public void connectionClosed(ClientDavInterface connection) {
        this.aktualisieren();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)new Separator("additions"));
        this.viewer.getControl().setMenu(menuManager.createContextMenu(this.viewer.getControl()));
        this.getSite().registerContextMenu(String.valueOf(ID) + ".contextMenu", menuManager, (ISelectionProvider)this.viewer);
    }

    public void createPartControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        Composite basisComposite = new Composite(parent, 0);
        basisComposite.setLayout((Layout)gridLayout);
        this.viewer = new TableViewer(basisComposite, 2816);
        Table table = this.viewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridData gridData1 = new GridData();
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.verticalAlignment = 4;
        gridData1.grabExcessVerticalSpace = true;
        gridData1.horizontalAlignment = 4;
        table.setLayoutData((Object)gridData1);
        SkriptLaufOverViewProvider provider = new SkriptLaufOverViewProvider();
        String[] columnNames = provider.getColumnNames();
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        String[] stringArray = columnNames;
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnName);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, 120));
            ++n2;
        }
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)provider);
        try {
            this.client = UdaToolsPlugin.getDefault().getConnector();
        }
        catch (MissingParameterException e) {
            throw new RuntimeException(e);
        }
        this.viewer.setInput((Object)this.client);
        for (ClientModul modul : this.client.getModule()) {
            modul.addClientListener((ModulListener)this);
            modul.addLaufListener((SkriptLaufListener)this);
        }
        this.createContextMenu();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HILFE_ID);
    }

    public void dispose() {
        if (this.client != null) {
            for (ClientModul modul : this.client.getModule()) {
                modul.removeClientListener((ModulListener)this);
                modul.removeLaufListener((SkriptLaufListener)this);
            }
        }
        try {
            UdaToolsPlugin.getDefault().getConnector().removeConnectionListener((UdaConnectionListener)this);
        }
        catch (MissingParameterException e) {
            e.printStackTrace();
        }
        super.dispose();
    }

    public void ergebnisAktualisiert(ClientSkriptLauf lauf) {
        this.aktualisieren();
    }

    public void meldungsListeAktualisiert(ClientSkriptLauf skript) {
    }

    public void neuerModulStatus(ClientModul modul, boolean valid) {
        this.aktualisieren();
    }

    public void skriptAktualisiert(ClientSkript skript) {
    }

    public void skriptAktualisiert(ClientSkriptLauf skript) {
        this.aktualisieren();
    }

    public void skriptAngelegt(ClientModul modul, ClientSkript skript) {
        this.aktualisieren();
    }

    public void skriptEntfernt(ClientModul modul, ClientSkript skript) {
        this.aktualisieren();
    }

    public void skriptLaufAngelegt(ClientModul modul, ClientSkriptLauf lauf) {
        this.aktualisieren();
    }

    public void skriptLaufEntfernt(ClientModul modul, ClientSkriptLauf lauf) {
        this.aktualisieren();
    }

    public void skriptZustandAktualisiert(ClientSkriptLauf skript) {
        this.aktualisieren();
    }

    public void setFocus() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }
}

