/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.uda.wizards;

import de.bsvrz.buv.plugin.uda.wizards.ProtokollTypProvider;
import de.bsvrz.ibv.uda.verwaltung.protokoll.DateiProtokoll;
import de.bsvrz.ibv.uda.verwaltung.protokoll.DavProtokoll;
import de.bsvrz.ibv.uda.verwaltung.protokoll.KonsoleProtokoll;
import de.bsvrz.ibv.uda.verwaltung.protokoll.LogProtokoll;
import de.bsvrz.ibv.uda.verwaltung.protokoll.Protokoll;
import de.bsvrz.ibv.uda.verwaltung.protokoll.ProtokollTyp;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class ProtokollDataPage
extends WizardPage {
    private ComboViewer protokollTypSelector;
    private Text nameField;
    private Spinner anzahlField;
    private Spinner groesseField;
    private final Protokoll protokoll;

    protected ProtokollDataPage(Protokoll protokoll) {
        super("Protokolldaten");
        this.setTitle("Protokollinformationen");
        this.setMessage("Geben Sie hier die Informationen zur Definition des Protokolls an");
        this.protokoll = protokoll;
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(parent, 0);
        label.setText("Protokolltyp: ");
        this.protokollTypSelector = new ComboViewer(parent, 0);
        this.protokollTypSelector.setContentProvider((IContentProvider)new ProtokollTypProvider());
        this.protokollTypSelector.setInput((Object)this);
        this.protokollTypSelector.getCombo().setLayoutData((Object)new GridData(1808));
        if (this.protokoll != null) {
            this.protokollTypSelector.setSelection((ISelection)new StructuredSelection((Object)this.protokoll.getTyp()));
        } else {
            this.protokollTypSelector.setSelection((ISelection)new StructuredSelection((Object)ProtokollTyp.KONSOLE));
        }
        label = new Label(parent, 0);
        label.setText("Name: ");
        this.nameField = new Text(parent, 2048);
        this.nameField.setLayoutData((Object)new GridData(768));
        if (this.protokoll != null) {
            this.nameField.setText(this.protokoll.getName());
        }
        label = new Label(parent, 0);
        label.setText("Anzahl: ");
        this.anzahlField = new Spinner(parent, 2048);
        this.anzahlField.setLayoutData((Object)new GridData(1808));
        if (this.protokoll != null) {
            this.anzahlField.setSelection((int)this.protokoll.getAnzahl());
        }
        label = new Label(parent, 0);
        label.setText("Gr\u00f6\u00dfe (MB): ");
        this.groesseField = new Spinner(parent, 2048);
        this.groesseField.setLayoutData((Object)new GridData(1808));
        if (this.protokoll != null) {
            this.groesseField.setSelection((int)this.protokoll.getMaxSize());
        }
        this.setControl((Control)parent);
    }

    public Protokoll getProtokoll() {
        ProtokollTyp typ = (ProtokollTyp)((IStructuredSelection)this.protokollTypSelector.getSelection()).getFirstElement();
        DateiProtokoll ausgewaehltesProtokoll = null;
        if (ProtokollTyp.DATEI.equals((Object)typ)) {
            ausgewaehltesProtokoll = new DateiProtokoll();
        } else if (ProtokollTyp.KONSOLE.equals((Object)typ)) {
            ausgewaehltesProtokoll = new KonsoleProtokoll();
        } else if (ProtokollTyp.DAV.equals((Object)typ)) {
            ausgewaehltesProtokoll = new DavProtokoll();
        } else if (ProtokollTyp.LOGGING.equals((Object)typ)) {
            ausgewaehltesProtokoll = new LogProtokoll();
        }
        if (ausgewaehltesProtokoll != null) {
            ausgewaehltesProtokoll.setAnzahl((long)this.anzahlField.getSelection());
            ausgewaehltesProtokoll.setMaxSize((long)this.groesseField.getSelection());
            ausgewaehltesProtokoll.setName(this.nameField.getText());
        }
        return ausgewaehltesProtokoll;
    }
}

