/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.uda.wizards;

import de.bsvrz.buv.plugin.uda.wizards.CreateProtokollWizard;
import de.bsvrz.ibv.uda.verwaltung.protokoll.Protokoll;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ProtokollDefinitionTable
extends Canvas
implements IStructuredContentProvider,
ITableLabelProvider,
ISelectionChangedListener,
DisposeListener {
    private Protokoll selectedProtokoll;
    private final List<Protokoll> protokolle = new ArrayList<Protokoll>();
    private final TableViewer viewer;
    private final String[] columnNames = new String[]{"Typ", "Name", "Anzahl", "Gr\u00f6\u00dfe"};
    private Button editButton;
    private Button deleteButton;

    public ProtokollDefinitionTable(Composite parent, Collection<Protokoll> initialeProtokolle) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(2, false));
        if (initialeProtokolle != null) {
            this.protokolle.addAll(initialeProtokolle);
        }
        this.createButtonArea();
        this.viewer = new TableViewer((Composite)this, 68354);
        Table table = this.viewer.getTable();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        TableColumn column = null;
        String[] stringArray = this.columnNames;
        int n = this.columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            column = new TableColumn(table, 0);
            column.setText(columnName);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
            ++n2;
        }
        table.setLayout((Layout)layout);
        this.viewer.setContentProvider((IContentProvider)this);
        this.viewer.setLabelProvider((IBaseLabelProvider)this);
        this.viewer.setInput((Object)this);
        this.addDisposeListener(this);
    }

    public void addListener(ILabelProviderListener listener) {
    }

    private void createButtonArea() {
        Canvas buttons = new Canvas((Composite)this, 0);
        buttons.setLayout((Layout)new GridLayout(1, true));
        Button button = new Button((Composite)buttons, 0);
        button.setText("Anlegen");
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CreateProtokollWizard wizard = new CreateProtokollWizard(ProtokollDefinitionTable.this.protokolle, null);
                WizardDialog dialog = new WizardDialog(ProtokollDefinitionTable.this.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    ProtokollDefinitionTable.this.viewer.refresh();
                }
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        this.editButton = new Button((Composite)buttons, 0);
        this.editButton.setText("Bearbeiten");
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CreateProtokollWizard wizard = new CreateProtokollWizard(ProtokollDefinitionTable.this.protokolle, ProtokollDefinitionTable.this.selectedProtokoll);
                WizardDialog dialog = new WizardDialog(ProtokollDefinitionTable.this.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    ProtokollDefinitionTable.this.viewer.refresh();
                }
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        this.editButton.setEnabled(false);
        this.deleteButton = new Button((Composite)buttons, 0);
        this.deleteButton.setText("L\u00f6schen");
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                Iterator iterator = ((IStructuredSelection)ProtokollDefinitionTable.this.viewer.getSelection()).iterator();
                while (iterator.hasNext()) {
                    ProtokollDefinitionTable.this.protokolle.remove(iterator.next());
                }
                ProtokollDefinitionTable.this.viewer.refresh();
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        this.deleteButton.setEnabled(false);
        button.pack();
    }

    public void widgetDisposed(DisposeEvent e) {
        this.protokolle.clear();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String result = "";
        Protokoll protokoll = (Protokoll)element;
        switch (columnIndex) {
            case 0: {
                result = protokoll.getTyp().toString();
                break;
            }
            case 1: {
                result = protokoll.getName();
                break;
            }
            case 2: {
                result = Long.toString(protokoll.getAnzahl());
                break;
            }
            case 3: {
                result = Long.toString(protokoll.getMaxSize());
                break;
            }
        }
        return result;
    }

    public Object[] getElements(Object inputElement) {
        return this.protokolle.toArray();
    }

    public Collection<Protokoll> getProtokolle() {
        return this.protokolle;
    }

    public void inputChanged(Viewer neuerViewer, Object oldInput, Object newInput) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object selected;
        this.selectedProtokoll = null;
        this.deleteButton.setEnabled(false);
        this.editButton.setEnabled(false);
        if (event.getSelection() instanceof IStructuredSelection && (selected = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof Protokoll) {
            this.selectedProtokoll = (Protokoll)selected;
            this.deleteButton.setEnabled(true);
            this.editButton.setEnabled(true);
        }
    }
}

