/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.uda.wizards;

import de.bsvrz.buv.plugin.uda.wizards.ProtokollDefinitionTable;
import de.bsvrz.buv.plugin.uda.wizards.StartTypProvider;
import de.bsvrz.buv.plugin.uda.wizards.UdaSkriptProvider;
import de.bsvrz.ibv.uda.client.ClientException;
import de.bsvrz.ibv.uda.client.ClientModul;
import de.bsvrz.ibv.uda.client.ClientSkript;
import de.bsvrz.ibv.uda.client.SkriptLaufDaten;
import de.bsvrz.ibv.uda.uda.data.Skript;
import de.bsvrz.ibv.uda.uda.data.SkriptLauf;
import de.bsvrz.ibv.uda.uda.data.StartTyp;
import de.bsvrz.ibv.uda.uda.data.StartZyklus;
import de.bsvrz.ibv.uda.verwaltung.protokoll.Protokoll;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SkriptLaufDataPage
extends WizardPage {
    private static final String REGEX_MINUS_NAME_GLEICH = "-{1}[a-zA-Z\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc]{1}[a-zA-Z0-9\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df]*={1}";
    private static final String REGEX_WERT = "((\".+?\")|([a-zA-Z0-9\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df]+))";
    private static final Pattern PATTERN_PARAMETERSATZ = Pattern.compile("-{1}[a-zA-Z\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc]{1}[a-zA-Z0-9\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df]*={1}((\".+?\")|([a-zA-Z0-9\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df]+))");
    private static final Pattern PATTER_NAME = Pattern.compile("-{1}[a-zA-Z\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc]{1}[a-zA-Z0-9\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df]*={1}");
    private Text nameField;
    private Text descField;
    private Text userField;
    private Text passwortField;
    private ComboViewer skriptSelector;
    private final Object element;
    private Text editUserField;
    private Text grundField;
    private ComboViewer startTypSelector;
    private ProtokollDefinitionTable protokollListe;
    private Text startZeitpunktField;
    private final SkriptLaufDaten skriptLaufDaten;
    private Text intervalField;
    private Text parameterField;

    protected SkriptLaufDataPage(ClientModul modul, SkriptLauf lauf) {
        super("Skriptlaufdaten");
        this.element = modul;
        this.setTitle("Skriptlaufinformationen");
        this.setMessage("Geben Sie hier die Informationen zur Definition des Skriptlaufs an");
        this.skriptLaufDaten = new SkriptLaufDaten(lauf);
    }

    public void createControl(Composite parent) {
        GridLayout pageLayout = new GridLayout();
        pageLayout.numColumns = 2;
        parent.setLayout((Layout)pageLayout);
        parent.setLayoutData((Object)new GridData(768));
        Label label = new Label(parent, 0);
        label.setText("Skript: ");
        this.skriptSelector = new ComboViewer(parent, 0);
        this.skriptSelector.setContentProvider((IContentProvider)new UdaSkriptProvider());
        this.skriptSelector.setComparator(new ViewerComparator());
        this.skriptSelector.setInput(this.element);
        this.skriptSelector.getCombo().setLayoutData((Object)new GridData(1808));
        if (this.skriptLaufDaten.getSkript() != null) {
            this.skriptSelector.setSelection((ISelection)new StructuredSelection((Object)this.skriptLaufDaten.getSkript()));
        } else {
            this.skriptSelector.setSelection(null);
        }
        label = new Label(parent, 0);
        label.setText("Skriptlaufname: ");
        this.nameField = new Text(parent, 2048);
        this.nameField.setLayoutData((Object)new GridData(768));
        this.nameField.setText(this.skriptLaufDaten.getName());
        label = new Label(parent, 0);
        label.setText("Beschreibung: ");
        this.descField = new Text(parent, 2048);
        this.descField.setLayoutData((Object)new GridData(1808));
        this.descField.setText(this.skriptLaufDaten.getBeschreibung());
        label = new Label(parent, 0);
        label.setText("Parameter: ");
        this.parameterField = new Text(parent, 2048);
        this.parameterField.setLayoutData((Object)new GridData(1808));
        this.parameterField.setText(this.getParameterString(this.skriptLaufDaten.getParameter()));
        label = new Label(parent, 0);
        label.setText("Benutzer: ");
        this.userField = new Text(parent, 2048);
        this.userField.setLayoutData((Object)new GridData(1808));
        this.userField.setText(this.skriptLaufDaten.getBenutzer());
        label = new Label(parent, 0);
        label.setText("Passwort: ");
        this.passwortField = new Text(parent, 0x400800);
        this.passwortField.setLayoutData((Object)new GridData(1808));
        this.passwortField.setText("");
        label = new Label(parent, 0);
        label.setText("Protokolle: ");
        new Label(parent, 0);
        this.protokollListe = new ProtokollDefinitionTable(parent, this.skriptLaufDaten.getProtokolle());
        GridData data = new GridData(1808);
        data.heightHint = 150;
        data.horizontalSpan = 2;
        this.protokollListe.setLayoutData(data);
        label = new Label(parent, 0);
        label.setText("Starttyp: ");
        this.startTypSelector = new ComboViewer(parent, 0);
        this.startTypSelector.setContentProvider((IContentProvider)new StartTypProvider());
        this.startTypSelector.setInput(this.element);
        this.startTypSelector.getCombo().setLayoutData((Object)new GridData(1808));
        this.startTypSelector.setSelection((ISelection)new StructuredSelection((Object)this.skriptLaufDaten.getStartTyp()));
        label = new Label(parent, 0);
        label.setText("Startzeitpunkt: ");
        this.startZeitpunktField = new Text(parent, 0);
        this.startZeitpunktField.setLayoutData((Object)new GridData(1808));
        this.startZeitpunktField.setText(DateFormat.getDateTimeInstance().format(new Date(this.skriptLaufDaten.getZyklus().getStartZeitPunkt())));
        label = new Label(parent, 0);
        label.setText("Intervall (in ms): ");
        this.intervalField = new Text(parent, 0);
        this.intervalField.setLayoutData((Object)new GridData(1808));
        this.intervalField.setText(Long.toString(this.skriptLaufDaten.getZyklus().getIntervall()));
        label = new Label(parent, 0);
        label.setText("Name des \u00e4ndernden Benutzers: ");
        this.editUserField = new Text(parent, 2048);
        this.editUserField.setLayoutData((Object)new GridData(1808));
        this.editUserField.setText(System.getProperty("user.name"));
        label = new Label(parent, 0);
        label.setText("Grund f\u00fcr die \u00c4nderung: ");
        this.grundField = new Text(parent, 2048);
        this.grundField.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)parent);
    }

    public String getEditBenutzerName() {
        return this.editUserField.getText();
    }

    public String getGrund() {
        return this.grundField.getText();
    }

    private Map<String, String> getLaufParameter() {
        HashMap<String, String> result = new HashMap<String, String>();
        Matcher matcher = PATTERN_PARAMETERSATZ.matcher(this.parameterField.getText());
        while (matcher.find()) {
            String wertRaw;
            String parameterSatz = this.parameterField.getText().substring(matcher.start(), matcher.end());
            Matcher nameRawMatcher = PATTER_NAME.matcher(parameterSatz);
            nameRawMatcher.find();
            String name = parameterSatz.substring(nameRawMatcher.start() + 1, nameRawMatcher.end() - 1);
            String wert = wertRaw = parameterSatz.substring(nameRawMatcher.end());
            if (wertRaw.startsWith("\"")) {
                wert = wertRaw.substring(1, wertRaw.length() - 1);
            }
            result.put(name, wert);
        }
        return result;
    }

    private String getParameterString(Map<String, String> liste) {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<String, String> entry : liste.entrySet()) {
            if (buffer.length() > 0) {
                buffer.append('|');
            }
            buffer.append(entry.getKey());
            String wert = entry.getValue();
            if (wert == null) continue;
            buffer.append('=');
            buffer.append(wert);
        }
        return buffer.toString();
    }

    public SkriptLaufDaten getSkriptLauf() throws ClientException {
        Date date;
        this.skriptLaufDaten.setBenutzer(this.userField.getText());
        this.skriptLaufDaten.setBeschreibung(this.descField.getText());
        String anmeldeName = this.nameField.getText();
        if (anmeldeName == null || anmeldeName.length() <= 0) {
            throw new ClientException("Es muss ein Name f\u00fcr  die Datenverteileranmeldung angegeben werden");
        }
        this.skriptLaufDaten.setName(anmeldeName);
        String passwd = this.passwortField.getText().trim();
        if (passwd.isEmpty()) {
            throw new ClientException("Es ist ein Passwort f\u00fcr die Dartenverteileranmeldung erforderlich");
        }
        this.skriptLaufDaten.setPasswd(passwd);
        this.skriptLaufDaten.setSkript((Skript)((ClientSkript)((IStructuredSelection)this.skriptSelector.getSelection()).getFirstElement()));
        this.skriptLaufDaten.setStartTyp((StartTyp)((IStructuredSelection)this.startTypSelector.getSelection()).getFirstElement());
        try {
            date = DateFormat.getDateTimeInstance().parse(this.startZeitpunktField.getText());
        }
        catch (ParseException e) {
            this.startZeitpunktField.setText(DateFormat.getDateInstance().format(new Date(System.currentTimeMillis())));
            throw new ClientException("Das eingegebene Startdatum ist ung\u00fcltig: " + e.getLocalizedMessage());
        }
        try {
            this.skriptLaufDaten.setZyklus(new StartZyklus(date.getTime(), Long.parseLong(this.intervalField.getText())));
        }
        catch (NumberFormatException e) {
            throw new ClientException("Der eingegebene Ausf\u00fchrungszyklus ist ung\u00fcltig: " + e.getLocalizedMessage());
        }
        this.skriptLaufDaten.clearProtokolle();
        for (Protokoll protokoll : this.protokollListe.getProtokolle()) {
            this.skriptLaufDaten.addProtokoll(protokoll);
        }
        this.skriptLaufDaten.clearParameter();
        Map<String, String> parameterListe = this.getLaufParameter();
        for (Map.Entry<String, String> entry : parameterListe.entrySet()) {
            this.skriptLaufDaten.setParameter(entry.getKey(), entry.getValue());
        }
        return this.skriptLaufDaten;
    }
}

