/*
 * Rahmenwerk-Plug-in "RDS-Detailanzeige"
 * Spezial-Plug-in VRZ3 - Baden-Württemberg
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.verkehrsmeldung.detail.perspective;

import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

import de.bsvrz.buv.plugin.verkehrsmeldung.detail.views.RdsDetailsView;
import de.bsvrz.buv.plugin.verkehrsmeldung.detail.views.Tic3MeldungenViewPart;

/**
 * Die Standardperspektive des Plug-ins.
 *
 * Innerhalb der Perspektive wird die Ansicht der TIC3-Meldungen und die
 * Detailansicht für ausgewählte Verkehrsmeldungen dargestellt.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker, Steffen Gieseler
 * 
 */
public class DefaultPerspective implements IPerspectiveFactory {

	/** die ID der Perspektive. */
	public static final String PERSPECTIVE_ID = "de.bsvrz.buv.plugin.verkehrsmeldung.detail.VerkehrsMeldungenDetailsPerspektive";

	@Override
	public void createInitialLayout(final IPageLayout layout) {
		final String editorArea = layout.getEditorArea();
		layout.setEditorAreaVisible(false);
		layout.addView(Tic3MeldungenViewPart.VIEW_ID, IPageLayout.TOP, 0.3f, editorArea);

		layout.addView(RdsDetailsView.VIEW_ID, IPageLayout.BOTTOM, 0.7f, editorArea);
	}
}
