/*
 * Rahmenwerk-Plug-in "RDS-Detailanzeige"
 * Spezial-Plug-in VRZ3 - Baden-Württemberg
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.verkehrsmeldung.detail.views;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;

import com.bitctrl.lib.eclipse.resources.WidgetFontRegistry;

import de.bsvrz.sys.funclib.bitctrl.modell.Aspekt;
import de.bsvrz.sys.funclib.bitctrl.modell.OnlineDatum.Status;
import de.bsvrz.sys.funclib.bitctrl.modell.att.Feld;
import de.bsvrz.sys.funclib.bitctrl.modell.att.Zeitstempel;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.objekte.TmcTic3infoMeldung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.onlinedaten.OdTmcTic3infoMeldung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.onlinedaten.OdTmcTic3infoMeldung.Daten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcBearbeitungsZustand;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcErzeugungsart;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcStatus;

/**
 * Label-Provider f&uuml;r TIC3-Meldungen-View.
 *
 * @author BitCtrl Systems GmbH, Steffen Gieseler
 */
public class Tic3MeldungenLabelProvider extends ColumnLabelProvider implements ITableLabelProvider, ITableFontProvider {

	/**
	 * Die Anzahl der Buchstaben, welche pro Zeile im Tooltip dargestellt werden
	 * sollen.
	 */
	private static final int TOOLTIP_WIDTH_HINT = 50;

	/** Style f&uuml;r Gruppierung. */
	private static final int GRUPPIERUNG_ROOT_STYLE = SWT.BOLD | SWT.ITALIC;

	/** Der zugeh&ouml;hrige View. */
	private final Tic3MeldungenViewPart view;

	/**
	 * Format der Zeitangabe.
	 */
	private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

	/**
	 * Konstruktor.
	 *
	 * @param meldungsView
	 *            View
	 */
	public Tic3MeldungenLabelProvider(final Tic3MeldungenViewPart meldungsView) {
		view = meldungsView;
	}

	@Override
	public Image getColumnImage(final Object element, final int columnIndex) {
		return null;
	}

	@Override
	public String getColumnText(final Object element, final int columnIndex) {

		if (element instanceof TmcTic3infoMeldung) {

			final TmcTic3infoMeldung meldung = (TmcTic3infoMeldung) element;

			if (meldung.getOdTmcTic3infoMeldung().getDatum(OdTmcTic3infoMeldung.Aspekte.LmsEmpfangen)
					.dGetDatenStatus() != Status.DATEN) {
				return "";
			}

			final Daten datum = meldung.getOdTmcTic3infoMeldung().getDatum(OdTmcTic3infoMeldung.Aspekte.LmsEmpfangen);
			// Debug.getLogger().fine("TIC3 LabelProvider: " +
			// wrapper.getTmcMeldung().getName());

			if (columnIndex == 0) { // Meldungstext
				return datum.getTIC3Beschreibung();
			} else if (columnIndex == 1) { // "TIC Id"
				return datum.getTIC3TicId();
			} else if (columnIndex == 2) { // Datenproduzent
				return datum.getTIC3Datenproduzent().trim();
			} else if (columnIndex == 3) { // Datenkennung
				return datum.getTIC3Datenkennung();
			} else if (columnIndex == 4) { // Dringlichkeit
				// final AttTic3Prioritaet tic3Prioritaet =
				// meldung.getOdTmcTic3infoMeldung()
				// .getDatum(OdTmcTic3infoMeldung.Aspekte.LmsEmpfangen).getTIC3Prioritaet();
				return datum.getTIC3Prioritaet().toString();
			} else if (columnIndex == 5) { // Datenerzeugungszeit
				final Feld<Zeitstempel> tic3Datenerzeugungszeit = datum.getTIC3Datenerzeugungszeit();
				if (tic3Datenerzeugungszeit.size() > 0) {
					return getZeitStempelText(new Date(tic3Datenerzeugungszeit.get(0).getTime()));
				}
			} else if (columnIndex == 6) { // Aktualisierungszeit
				final Feld<Zeitstempel> tic3zeit = datum.getTIC3Objektversionserzeugungszeit();
				if (tic3zeit.size() > 0) {
					return getZeitStempelText(new Date(tic3zeit.get(0).getTime()));
				}
			} else if (columnIndex == 7) { // Status
				return datum.getTIC3Status().toString();
			} else if (columnIndex == 8) { // PID
				return meldung.getPid();
			}
		}

		// if (element instanceof Aspekt && (columnIndex == 0)) {
		// return ((Aspekt) element).getName();
		// }
		//
		// if (element instanceof AttTmcStatus && (columnIndex == 0)) {
		// return ((AttTmcStatus) element).toString();
		// }
		//
		// if (element instanceof AttTmcBearbeitungsZustand && (columnIndex ==
		// 0)) {
		// return ((AttTmcBearbeitungsZustand) element).toString();
		// }
		//
		// if (element instanceof AttTmcErzeugungsart && (columnIndex == 0)) {
		// return ((AttTmcErzeugungsart) element).toString();
		// }

		return "";
	}

	@Override
	public Font getFont(final Object element, final int index) {
		// if (!PluginEinstellungen.getInstance().getMeldungenEinstellung()
		// .isUseColors()) {
		// return null;
		// }

		if ((element instanceof Aspekt) || (element instanceof AttTmcStatus)
				|| (element instanceof AttTmcBearbeitungsZustand) || (element instanceof AttTmcErzeugungsart)) {
			final WidgetFontRegistry sr = WidgetFontRegistry.getInstance();
			final String fontKey = "RdsGruppierungRootStyle";

			Font gfont;

			if (!sr.hasValueFor(fontKey)) {
				final FontData[] fontData = view.getViewSite().getWorkbenchWindow().getWorkbench().getDisplay()
						.getSystemFont().getFontData();

				final FontData fontDatan = new FontData(fontData[0].getName(), fontData[0].getHeight(),
						Tic3MeldungenLabelProvider.GRUPPIERUNG_ROOT_STYLE);

				gfont = new Font(view.getViewSite().getWorkbenchWindow().getWorkbench().getDisplay(),
						new FontData[] { fontDatan });

				sr.put(fontKey, new FontData[] { fontDatan });
			} else {
				gfont = sr.get(fontKey);
			}
			return gfont;
		}
		return null;
	}

	@Override
	public String getText(final Object element) {
		if (element instanceof TmcTic3infoMeldung) {
			return ((TmcTic3infoMeldung) element).getOdTmcTic3infoMeldung()
					.getDatum(OdTmcTic3infoMeldung.Aspekte.LmsEmpfangen).getTIC3Beschreibung();
		}
		return super.getText(element);
	}

	@Override
	public String getToolTipText(final Object element) {
		if (element instanceof TmcTic3infoMeldung) {
			final StringBuffer buf = new StringBuffer();

			// (1) Stellt ggf. bei invaliden Meldungen ein 'INVALID' davor
			final TmcTic3infoMeldung wrapper = (TmcTic3infoMeldung) element;
			if (!wrapper.getSystemObject().isValid()) {
				buf.append("INVALID: ");
			}

			// (2) Meldungstext wird ggf. auf mehrere Zeilen umgebrochen
			final String meldungsText = getText(element);
			int startIndex = 0;
			int endIndex = meldungsText.indexOf(" ", startIndex + Tic3MeldungenLabelProvider.TOOLTIP_WIDTH_HINT);
			while ((endIndex < meldungsText.length()) && (endIndex != -1)) {
				if (startIndex != 0) {
					buf.append("\n");
				}
				buf.append(meldungsText.substring(startIndex, endIndex));
				startIndex = endIndex + 1;
				endIndex = meldungsText.indexOf(" ", startIndex + 50);
			}
			if (startIndex < meldungsText.length()) {
				buf.append("\n");
				buf.append(meldungsText.substring(startIndex));
			}

			return buf.toString();
		} else if (element instanceof Aspekt) {
			// TODO Workaround, weil toString f�r Aspekt potentiell eine NPE
			// wirft
			return ((Aspekt) element).getName() + " (" + ((Aspekt) element).getPid() + ")";
		}

		return "Tooltip (" + element + ")";
	}

	/**
	 *
	 *
	 * @param aktualisierungzeit
	 * @return
	 */
	private String getZeitStempelText(final Date zeit) {
		if (zeit == null) {
			return "nicht gesetzt";
		}

		return simpleDateFormat.format(zeit);
	}

	// @Override
	// public Point getToolTipShift(final Object object) {
	// return new Point(5, 5);
	// }
	//
	// @Override
	// public int getToolTipDisplayDelayTime(final Object object) {
	// return 2000;
	// }
	//
	// @Override
	// public int getToolTipTimeDisplayed(final Object object) {
	// return 5000;
	// }

	@Override
	public void update(final ViewerCell cell) {
		final Object obj = cell.getElement();
		final int columnIndex = cell.getColumnIndex();

		cell.setText(getColumnText(obj, columnIndex));
		cell.setFont(getFont(obj, columnIndex));
	}
}
