/*
 * Rahmenwerk-Plug-in "RDS-Detailanzeige"
 * Spezial-Plug-in VRZ3 - Baden-Württemberg
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.verkehrsmeldung.detail.views;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

import de.bsvrz.sys.funclib.bitctrl.modell.att.Feld;
import de.bsvrz.sys.funclib.bitctrl.modell.att.Zeitstempel;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.objekte.TmcTic3infoMeldung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.onlinedaten.OdTmcTic3infoMeldung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.onlinedaten.OdTmcTic3infoMeldung.Daten;

/**
 * {@link ViewerComparator} für den TableViewer der TIC3-Meldungen-Ansicht.
 *
 * @author BitCtrl Systems GmbH, Steffen Gieseler
 * 
 */
public class Tic3MeldungenTableSorter extends ViewerComparator {

	/**
	 * Maximaler Wert für den Spaltenindex.
	 */
	private static final int MAX_SPALTEN_INDEX = 8;

	/**
	 * Aufsteigende Sortierreihenfolge.
	 */
	public static final int AUFSTEIGEND = 0;

	/**
	 * Absteigende Sortierreihenfolge.
	 */
	public static final int ABSTEIGEND = 1;

	/**
	 * Der aktuelle Spaltenindex.
	 */
	private int aktuellerSpaltenIndex;

	/**
	 * Die aktuell ausgewählte Sortierrichtung.
	 */
	private int aktuelleRichtung = Tic3MeldungenTableSorter.AUFSTEIGEND;

	/**
	 * Der Default-Konstruktor.
	 *
	 * @param spaltenIndex
	 *            der aktuelle Spaltenindex
	 * @param richtung
	 *            die aktuelle Richtung
	 */
	public Tic3MeldungenTableSorter(final Integer spaltenIndex, final Integer richtung) {
		if (spaltenIndex != null) {
			aktuellerSpaltenIndex = spaltenIndex;
		}
		if ((aktuellerSpaltenIndex < 0) || (aktuellerSpaltenIndex > Tic3MeldungenTableSorter.MAX_SPALTEN_INDEX)) {
			aktuellerSpaltenIndex = 0;
		}
		if (richtung != null) {
			aktuelleRichtung = richtung;
		}
		if ((aktuelleRichtung != Tic3MeldungenTableSorter.AUFSTEIGEND)
				&& (aktuelleRichtung != Tic3MeldungenTableSorter.ABSTEIGEND)) {
			aktuelleRichtung = Tic3MeldungenTableSorter.AUFSTEIGEND;
		}
	}

	@Override
	public int compare(final Viewer viewer, final Object o1, final Object o2) {

		if ((o1 instanceof TmcTic3infoMeldung) && (o2 instanceof TmcTic3infoMeldung)) {
			final TmcTic3infoMeldung w1 = (TmcTic3infoMeldung) o1;
			final TmcTic3infoMeldung w2 = (TmcTic3infoMeldung) o2;
			final Daten datum1 = w1.getOdTmcTic3infoMeldung().getDatum(OdTmcTic3infoMeldung.Aspekte.LmsEmpfangen);
			final Daten datum2 = w2.getOdTmcTic3infoMeldung().getDatum(OdTmcTic3infoMeldung.Aspekte.LmsEmpfangen);

			int wert = 0;
			switch (aktuellerSpaltenIndex) {
			case 0:
				wert = datum1.getTIC3Beschreibung().compareTo(datum2.getTIC3Beschreibung());
				break;
			case 1:
				wert = datum1.getTIC3TicId().compareTo(datum2.getTIC3TicId());
				break;
			case 2:
				wert = datum1.getTIC3Datenproduzent().compareTo(datum2.getTIC3Datenproduzent());
				break;
			case 3:
				wert = datum1.getTIC3Datenkennung().compareTo(datum2.getTIC3Datenkennung());
				break;
			case 4:
				wert = datum1.getTIC3Prioritaet().compareTo(datum2.getTIC3Prioritaet());
				break;
			case 5:
				final Feld<Zeitstempel> zeit1 = datum1.getTIC3Datenerzeugungszeit();
				final Feld<Zeitstempel> zeit2 = datum2.getTIC3Datenerzeugungszeit();
				if ((zeit1.size() > 0) && (zeit2.size() > 0)) {
					wert = zeit1.get(0).compareTo(zeit2.get(0));
				}
				break;
			case 6:
				final Feld<Zeitstempel> azeit1 = datum1.getTIC3Objektversionserzeugungszeit();
				final Feld<Zeitstempel> azeit2 = datum2.getTIC3Objektversionserzeugungszeit();
				if ((azeit1.size() > 0) && (azeit2.size() > 0)) {
					wert = azeit1.get(0).compareTo(azeit2.get(0));
				}
				break;
			case 7:
				wert = datum1.getTIC3Status().compareTo(datum2.getTIC3Status());
				break;
			case 8:
				wert = w1.getPid().compareTo(w2.getPid());
				break;
			default:
				wert = 0;
			}

			// Bei absteigender Richtung, dreh den berechneten Wert um
			if (aktuelleRichtung == Tic3MeldungenTableSorter.ABSTEIGEND) {
				wert = -wert;
			}
			return wert;
			// } else if ((o1 instanceof AttTmcBearbeitungsZustand) && (o2
			// instanceof AttTmcBearbeitungsZustand)) {
			// return ((AttTmcBearbeitungsZustand)
			// o1).getValue().compareTo(((AttTmcBearbeitungsZustand)
			// o2).getValue());
			// } else if ((o1 instanceof AttTmcStatus) && (o2 instanceof
			// AttTmcStatus)) {
			// return ((AttTmcStatus) o1).getValue().compareTo(((AttTmcStatus)
			// o2).getValue());
			// } else if ((o1 instanceof AttTmcErzeugungsart) && (o2 instanceof
			// AttTmcErzeugungsart)) {
			// return ((AttTmcErzeugungsart)
			// o1).getValue().compareTo(((AttTmcErzeugungsart) o2).getValue());
			// } else if ((o1 instanceof Aspekt) && (o2 instanceof Aspekt)) {
			// return getValueForAspekt((Aspekt)
			// o1).compareTo(getValueForAspekt((Aspekt) o2));
		}
		return super.compare(viewer, o1, o2);
	}

	/**
	 * Liefert die aktuelle Richtung zurück, in welche die aktuelle Spalte der
	 * Tabelle sortiert wird.
	 *
	 * @return die aktuelle Richtung, in welche die aktuelle Spalte der Tabelle
	 *         sortiert wird
	 */
	public int getRichtung() {
		return aktuelleRichtung;
	}

	/**
	 * Liefert den Index der Spalte zurück, nach welcher die Tabelle aktuell
	 * sortiert wird.
	 *
	 * @return den Index der Spalte, nach welcher die Tabelle aktuell sortiert
	 *         wird
	 */
	public int getSpalte() {
		return aktuellerSpaltenIndex;
	}

	// /**
	// * Liefert einen entsprechenden Byte-Wert für den gegeben Aspekt zurück,
	// * über welchen dieser sortiert werden kann.
	// *
	// * @param aspekt
	// * der Aspekt
	// *
	// * @return einen entsprechenden Byte-Wert für den gegeben Aspekt
	// */
	// private Byte getValueForAspekt(final Aspekt aspekt) {
	// if (aspekt == PdTmcVerkehrsMeldung.Aspekte.TmcGeneriert) {
	// return 1;
	// } else if (aspekt == PdTmcVerkehrsMeldung.Aspekte.TmcSenden) {
	// return 2;
	// } else if (aspekt == PdTmcVerkehrsMeldung.Aspekte.TmcVersendet) {
	// return 3;
	// } else if (aspekt == PdTmcVerkehrsMeldung.Aspekte.TmcEmpfangen) {
	// return 4;
	// }
	// return 0;
	// }

	/**
	 * Setzt die Spalte nach welcher die Tabelle sortiert werden soll.
	 *
	 * @param spaltenIndex
	 *            der Index der Spalte
	 */
	public void setSpalte(final int spaltenIndex) {
		if (spaltenIndex == aktuellerSpaltenIndex) {
			// Same column as last sort; toggle the direction
			aktuelleRichtung = 1 - aktuelleRichtung;
		} else {
			// New column; do an ascending sort
			aktuellerSpaltenIndex = spaltenIndex;
			aktuelleRichtung = Tic3MeldungenTableSorter.AUFSTEIGEND;
		}
	}
}
