/*
 * Rahmenwerk-Plug-in "RDS-Detailanzeige"
 * Spezial-Plug-in VRZ3 - Baden-Württemberg
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.verkehrsmeldung.detail.views;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import de.bsvrz.buv.plugin.verkehrsmeldung.detail.internal.RahmenwerkService;
import de.bsvrz.sys.funclib.bitctrl.modell.AenderbareMenge;
import de.bsvrz.sys.funclib.bitctrl.modell.MengenEvent;
import de.bsvrz.sys.funclib.bitctrl.modell.MengenListener;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.objekte.Tic3LandesMeldeStelle;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.objekte.TmcTic3infoMeldung;

/**
 * ContentProvider f&uuml;r Ansicht 'TIC3-Meldungen'.
 *
 * @author BitCtrl Systems GmbH, Gieseler
 */

public class Tic3MeldungenViewContentProvider implements ITreeContentProvider, MengenListener {

	/** Die Ansicht 'TIC3-Meldungen'. */
	private final Tic3MeldungenViewPart view;

	/**
	 * Konstruktor.
	 *
	 * @param view die Ansicht 'TIC3-Meldungen'
	 */
	public Tic3MeldungenViewContentProvider(final Tic3MeldungenViewPart view) {
		this.view = view;

		final SystemObjekt modellobjekt = RahmenwerkService.getService().getLandesMeldeStelle();
		if (modellobjekt instanceof Tic3LandesMeldeStelle) {
			((Tic3LandesMeldeStelle) modellobjekt).getTMCTIC3Meldungen().addMengenListener(this);
		}
	}

	@Override
	public void dispose() {
		// do nothing
	}

	@Override
	public Object[] getChildren(final Object element) {
		final Collection<Object> result = new ArrayList<>();
		// final TmcTic3infoMeldung i;

		if (element instanceof Tic3MeldungenViewPart) {
			final SystemObjekt modellobjekt = RahmenwerkService.getService().getLandesMeldeStelle();

			if (modellobjekt instanceof Tic3LandesMeldeStelle) {
				final AenderbareMenge<TmcTic3infoMeldung> tmctic3Meldungen = ((Tic3LandesMeldeStelle) modellobjekt)
						.getTMCTIC3Meldungen();
				result.addAll(tmctic3Meldungen);
			}
		}

		return result.toArray(new Object[result.size()]);
	}

	@Override
	public Object[] getElements(final Object element) {
		return getChildren(element);
	}

	@Override
	public Object getParent(final Object element) {
		// if (element instanceof Aspekt || element instanceof AttTmcStatus ||
		// element instanceof AttTmcBearbeitungsZustand
		// || element instanceof AttTmcErzeugungsart) {
		return view;
		// }
		//
		// if (element instanceof TmcMeldungWrapper) {
		// final TmcMeldungWrapper wrapper = (TmcMeldungWrapper) element;
		//
		// switch (view.getGruppierung()) {
		// case ASPEKT:
		// return wrapper.getAspekt();
		//
		// case STATUS:
		// return wrapper.getStatus();
		//
		// case ZUSTAND:
		// return wrapper.getZustand();
		//
		// case QUELLE:
		// return wrapper.getQuelle();
		//
		// case KEINE:
		// return view;
		//
		// default:
		// break;
		// }
		// }
		// return null;
	}

	@Override
	public boolean hasChildren(final Object element) {
		return getChildren(element).length > 0;
	}

	@Override
	public void inputChanged(final Viewer viewer, final Object oldInput, final Object newInput) {
		// do nothing
	}

	@Override
	public void mengeAktualisiert(final MengenEvent e) {
		view.refresh();
	}
}
