/*
 * Rahmenwerk-Plug-in "RDS-Detailanzeige"
 * Spezial-Plug-in VRZ3 - Baden-Württemberg
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.verkehrsmeldung.detail.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

import com.bitctrl.lib.eclipse.actions.ShowTextFilterAction;
import com.bitctrl.lib.eclipse.help.DefaultHelpContext;

import de.bsvrz.buv.plugin.selektion.SelektionsListener;
import de.bsvrz.buv.plugin.selektion.SelektionsTransfer;
import de.bsvrz.buv.plugin.verkehrsmeldung.detail.internal.RahmenwerkService;
import de.bsvrz.buv.rw.bitctrl.eclipse.PatternOrSubstringFilter;
import de.bsvrz.sys.funclib.bitctrl.modell.AenderbareMenge;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.objekte.Tic3LandesMeldeStelle;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.objekte.TmcTic3infoMeldung;

/**
 * Die Ansicht "TIC3-Meldungen".
 *
 * @author BitCtrl Systems GmbH, Steffen Gieseler
 */
public class Tic3MeldungenViewPart extends ViewPart implements SelektionsListener {

//	/**
//	 * Hilfsklasse zur Verwaltung der Spaltensichtbarkeiten.
//	 *
//	 * @author BitCtrl Systems GmbH, Andreas Meissner
//	 */
//	private static class ColumnMenuHelper {
//
//		/** Die Sichtbarkeit. */
//		private final boolean visibility;
//
//		/** Die Tabellenspalte. */
//		private final TreeViewerColumn column;
//
//		/**
//		 * Der Konstruktor.
//		 *
//		 * @param visibility die Sichtbarkeit
//		 * @param column2    die Tabellenspalte
//		 */
//		ColumnMenuHelper(final boolean visibility, final TreeViewerColumn column2) {
//			this.visibility = visibility;
//			column = column2;
//		}
//	}

	/** die ID der Ansicht der TIC3-Meldungen. */
	public static final String VIEW_ID = "de.bsvrz.buv.plugin.verkehrsmeldung.detail.views.Tic3MeldungenView";

	/**
	 * Der Schlüssel, welcher zum Merken der Spaltenbreite genutzt wird.
	 */
	private static final String KEY_WIDTH = "columnWidth";

	/** Der Tree-Viewer. */
	private FilteredTree filteredTree;

	/** Aktion zum Aktualisieren der Ansicht. */
	private Tic3MeldungenTableSorter tableSorter;

	/**
	 * Flag, welches angibt, ob die Breiten einer Spalte gespeichert werden sollen.
	 */
	private boolean storeWidth;

	/** Aktion zum Ein- bzw. Ausblenden des Text-Filters. */
	private ShowTextFilterAction zeigeTextFilterAction;

	/**
	 * PartListener, welcher beim Schließen der View das Laden der Einstellungen
	 * initiiert.
	 */
	private final IPartListener partListener = new IPartListener() {

		@Override
		public void partActivated(final IWorkbenchPart part) {
			// tut nix
		}

		@Override
		public void partBroughtToTop(final IWorkbenchPart part) {
			// tut nix
		}

		@Override
		public void partClosed(final IWorkbenchPart part) {
			// tut nichts
		}

		@Override
		public void partDeactivated(final IWorkbenchPart part) {
			// tut nix
		}

		@Override
		public void partOpened(final IWorkbenchPart part) {
			// tut nix
		}
	};

	/**
	 * Label-Provider.
	 */
	private Tic3MeldungenLabelProvider labelProvider;

	/**
	 * UIJob, welcher die Aktualisierung der Content-Description dieser Ansicht
	 * initiiert.
	 */
	private UIJob updateContentDescriptionJob;

	@Override
	public boolean aktuelleSelektionBeobachten() {
		return true;
	}

	protected void clearViewer() {
		if ((filteredTree != null) && (filteredTree.getViewer() != null)) {
			filteredTree.getViewer().setInput(null);
		}
	}

	@Override
	public void createPartControl(final Composite parent) {

		final PatternOrSubstringFilter patternOrSubstringFilter = new PatternOrSubstringFilter();
		filteredTree = new FilteredTree(parent, SWT.MULTI | SWT.FULL_SELECTION, patternOrSubstringFilter, true);

		final Tree tree = filteredTree.getViewer().getTree();
		tree.setHeaderVisible(true);
		tree.setLinesVisible(true);

		labelProvider = new Tic3MeldungenLabelProvider(this);
		filteredTree.getViewer().setLabelProvider(labelProvider);
		filteredTree.getViewer().setContentProvider(new Tic3MeldungenViewContentProvider(this));

		erzeugeSpalten();

		filteredTree.getViewer().setFilters(new ViewerFilter[] { patternOrSubstringFilter });

		filteredTree.getFilterControl().addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(final ModifyEvent e) {
				if (updateContentDescriptionJob == null) {
					updateContentDescriptionJob = new UIJob(getSite().getShell().getDisplay(),
							"Aktualisiere Inhaltsbeschreibung der Ansicht 'TIC3-Meldungen'") {

						@Override
						public IStatus runInUIThread(final IProgressMonitor monitor) {
							setContentDescription();
							return Status.OK_STATUS;
						}
					};
				}
				updateContentDescriptionJob.cancel();
				updateContentDescriptionJob.schedule(250);
			}
		});

		// Setze initiale Sortierung
		final int columnIndex = 0;
		final int richtung = Tic3MeldungenTableSorter.AUFSTEIGEND;

		tableSorter = new Tic3MeldungenTableSorter(columnIndex, richtung);
		filteredTree.getViewer().setComparator(tableSorter);

		final int dir = SWT.UP;
		tree.setSortColumn(tree.getColumn(columnIndex));
		tree.setSortDirection(dir);

		// abschließende Initialisierung
		getSite().setSelectionProvider(filteredTree.getViewer());
		SelektionsTransfer.getInstanz().addSelektionsListener(this);

		// Tooltip
		ColumnViewerToolTipSupport.enableFor(filteredTree.getViewer(), ToolTip.NO_RECREATE);

		filteredTree.getViewer().setInput(this);

		fuelleActionBars();

		DefaultHelpContext.registerDefaultHelpContext(filteredTree.getViewer().getControl(),
				Tic3MeldungenViewPart.class);
	}

	/**
	 * Erzeugte eine neue Tabellenspalte.
	 *
	 * @param parent          die Tabelle, die neu erzeugte Tabellenspalte enthalten
	 *                        soll
	 * @param columnIndex     der Spaltenindex
	 * @param name            der Name
	 * @param tooltip         der Tooltip
	 * @param alignment       die Ausrichtung
	 * @param width           die Breite
	 * @param visible         die Sichtbarkeit
	 * @param createMenuEntry <code>true</code>, wenn für diese Spalte ein
	 *                        Menüeintrag zum Ein- bzw. Ausblenden der Spalte
	 *                        erzeugte werden soll, ansonsten <code>false</code>
	 *
	 * @return die neu erzeugte Tabellenspalte
	 */
	private TreeViewerColumn createTableColumn(final Tree parent, final int columnIndex, final String name,
			final String tooltip, final int alignment, final int width, final boolean visible,
			final boolean createMenuEntry) {

		final int theWidth = width;
		final TreeViewerColumn column = new TreeViewerColumn(filteredTree.getViewer(), alignment);
		column.setLabelProvider(labelProvider);
		final TreeColumn treeColumn = column.getColumn();
		treeColumn.setText(name);

		// if (einstellungen != null) {
		// final List<Integer> spaltenBreiten =
		// einstellungen.getSpaltenBreiten();
		// if ((spaltenBreiten != null) && (spaltenBreiten.size() >
		// columnIndex)) {
		// final int storedWidth = spaltenBreiten.get(columnIndex);
		// if (storedWidth > 0) {
		// theWidth = storedWidth;
		// }
		// }
		// }
		treeColumn.setWidth(theWidth);
		treeColumn.setData(Tic3MeldungenViewPart.KEY_WIDTH, theWidth);
		treeColumn.setResizable(true);
		treeColumn.setMoveable(false);

		treeColumn.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(final SelectionEvent e) {
				final Cursor loadCursor = new Cursor(parent.getDisplay(), SWT.CURSOR_WAIT);
				parent.setCursor(loadCursor);

				tableSorter.setSpalte(columnIndex);
				final Tree tree = filteredTree.getViewer().getTree();
				tree.setSortDirection(
						(tableSorter.getRichtung() == Tic3MeldungenTableSorter.AUFSTEIGEND) ? SWT.UP : SWT.DOWN);
				tree.setSortColumn(treeColumn);
				filteredTree.getViewer().refresh();

				parent.setCursor(null);
				loadCursor.dispose();
			}
		});

		treeColumn.addControlListener(new ControlAdapter() {
			@Override
			public void controlResized(final ControlEvent e) {
				if (storeWidth) {
					treeColumn.setData(Tic3MeldungenViewPart.KEY_WIDTH, treeColumn.getWidth());
				}
			}
		});

		final boolean visibility = visible;
		setTableColumnVisible(column, visibility, theWidth);

		return column;
	}

	@Override
	public boolean definierteSelektionenBeobachten(final String... namen) {
		return false;
	}

	@Override
	public void dispose() {
		SelektionsTransfer.getInstanz().removeSelektionsListener(this);
		getSite().getPage().removePartListener(partListener);
		super.dispose();
	}

	/**
	 * Erzeugt die Spalten.
	 */
	private void erzeugeSpalten() {
		final Tree tree = filteredTree.getViewer().getTree();
		createTableColumn(tree, 0, "Meldungstext", "Meldungstext", SWT.LEFT, 450, true, false);
		createTableColumn(tree, 1, "TIC Id", "TIC Id", SWT.LEFT, 170, true, true);
		createTableColumn(tree, 2, "Datenproduzent", "Datenproduzent", SWT.LEFT, 130, true, true);
		createTableColumn(tree, 3, "Datenkennung", "Datenkennung", SWT.LEFT, 110, true, true);
		createTableColumn(tree, 4, "Dringlichkeit", "Dringlichkeit", SWT.LEFT, 90, true, true);
		createTableColumn(tree, 5, "Datenerzeugungszeit", "Datenerzeugungszeit", SWT.LEFT, 150, true, true);
		createTableColumn(tree, 6, "Aktualisierungszeit", "Aktualisierungszeit", SWT.LEFT, 150, true, true);
		createTableColumn(tree, 7, "Status", "Status", SWT.LEFT, 80, true, true);
		createTableColumn(tree, 8, "PID", "PID", SWT.LEFT, 80, true, true);
	}

	/**
	 * Füllt das Menü und die Symbolleiste dieser Ansicht mit Aktionen.
	 */
	private void fuelleActionBars() {

		zeigeTextFilterAction = new ShowTextFilterAction(filteredTree);

		final IActionBars bars = getViewSite().getActionBars();
		final IMenuManager menu = bars.getMenuManager();
		menu.add(zeigeTextFilterAction);
		zeigeTextFilterAction.setChecked(true);
		zeigeTextFilterAction.run();

		getViewSite().getActionBars().updateActionBars();
	}

	@Override
	public void init(final IViewSite site, final IMemento mem) throws PartInitException {
		super.init(site, mem);
		getSite().getPage().addPartListener(partListener);
	}

	/**
	 * Liefert <code>true</code> zurück, wenn die gegebene Meldung den aktuell
	 * gesetzten Filter passiert.
	 *
	 * @param wrapper die Meldung
	 *
	 * @return <code>true</code> zurück, wenn die gegebene Meldung den aktuell
	 *         gesetzten Filter passiert, ansonsten <code>false</code>
	 */
	private boolean passiertAktuellenFilter(final TmcTic3infoMeldung wrapper) {
		return true;
	}

	/**
	 *
	 *
	 */
	public void refresh() {
		if (filteredTree.getViewer().getControl().isDisposed()) {
			return;
		}

		filteredTree.getViewer().getControl().getDisplay().asyncExec(new Runnable() {
			@Override
			public void run() {
				filteredTree.getViewer().refresh();
				setContentDescription();
			}
		});
	}

	@Override
	public void selectionChanged(final IWorkbenchPart part, final ISelection selection) {

		if (part == this) {
			return;
		}
	}

	/**
	 * Aktualisiert die Content-Description dieser Ansicht.
	 */
	private void setContentDescription() {

		if (!RahmenwerkService.getService().isAusfuehrbar()) {
			setContentDescription("Plugin ist nicht ausführbar!");
			return;
		}

		final SystemObjekt modellobjekt = RahmenwerkService.getService().getObjektFactory()
				.getModellobjekt(RahmenwerkService.getService().getLandesMeldeStelle().getPid());

		AenderbareMenge<TmcTic3infoMeldung> tmctic3Meldungen = null;

		int anzahlMeldungen = 0;
		int anzahlGefilterteMeldungen = 0;

		if (modellobjekt instanceof Tic3LandesMeldeStelle) {
			tmctic3Meldungen = ((Tic3LandesMeldeStelle) modellobjekt).getTMCTIC3Meldungen();

			anzahlMeldungen = tmctic3Meldungen.size();

			for (final TmcTic3infoMeldung wrapper : tmctic3Meldungen) {
				if (!passiertAktuellenFilter(wrapper)
						|| !filteredTree.getPatternFilter().isElementVisible(filteredTree.getViewer(), wrapper)) {
					anzahlGefilterteMeldungen++;
				}
			}
		}

		final StringBuffer buf = new StringBuffer();
		final int anzahlAngezeigterMeldungen = anzahlMeldungen - anzahlGefilterteMeldungen;
		buf.append(anzahlAngezeigterMeldungen);
		buf.append(" TIC3-Meldung");
		if (anzahlAngezeigterMeldungen != 1) {
			buf.append("en");
		}

		if (anzahlGefilterteMeldungen > 0) {
			buf.append(" (");
			buf.append(anzahlGefilterteMeldungen);
			buf.append(" gefilterte TIC3-Meldung");
			if (anzahlGefilterteMeldungen != 1) {
				buf.append("en");
			}
			buf.append(")");
		}
		setContentDescription(buf.toString());
	}

	@Override
	public void setFocus() {
		if (filteredTree != null) {
			final TreeViewer viewer = filteredTree.getViewer();
			if ((viewer != null) && !viewer.getControl().isDisposed()) {
				viewer.getControl().setFocus();
			}
		}
	}

	/**
	 * Setzt die Sichtbarkeit einer Tabellespalte.
	 *
	 * @param column      die Tabellenspalte
	 * @param visible     die Sichtbarkeit
	 * @param columnWidth die Spaltenbreite
	 */
	private void setTableColumnVisible(final TreeViewerColumn column, final boolean visible, final int columnWidth) {
		storeWidth = false;
		column.getColumn().setWidth(visible ? columnWidth : 0);
		column.getColumn().setResizable(visible);
		storeWidth = true;
	}

	@Override
	public boolean vorigeSelektionBeobachten() {
		return false;
	}
}
