/*******************************************************************************
 * Basis-Plug-In fr die Darstellung von Charts mit BIRT
 * Copyright (C) 2009 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 ******************************************************************************/
package com.bitctrl.lib.eclipse.birt.chart;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

import com.bitctrl.lib.eclipse.actions.CopyAction;

/**
 * Kopiert die aktuell angezeigte Grafik in die Zwischenablage.
 *
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 * @version $Id: $
 */
public class CopyChartAction extends CopyAction {
	private final ChartCanvas canvas;
	private final int xRes;
	private final int yRes;

	public CopyChartAction(final ChartCanvas canvas, final int xRes, final int yRes) {
		this.canvas = canvas;
		this.xRes = xRes;
		this.yRes = yRes;
		setToolTipText("Diagramm als Bild kopieren");
	}

	@Override
	public void runWithEvent(final Event event) {
		final Display current = Display.getCurrent();
		final Clipboard clipboard = new Clipboard(current);
		try {
			// Initialize.
			final PlatformConfig config = new PlatformConfig();
			config.setProperty("STANDALONE", "true"); //$NON-NLS-1$ //$NON-NLS-2$
			final IDeviceRenderer render = ChartEngine.instance(config).getRenderer("dv.BMP");//$NON-NLS-1$
			final Generator gr = Generator.instance();

			final Point dpi = current.getDPI();
			final GeneratedChartState state = gr.build(render.getDisplayServer(), pimpChart(72.0 /* Display */
					* 2 /* dpi.x + dpi.y */
					/ (dpi.x + dpi.y)), BoundsImpl.create(0, 0, xRes * 72 / dpi.x, yRes * 72 / dpi.y), null, null,
					null);
			// Render
			final ByteArrayOutputStream baos = new ByteArrayOutputStream();
			final BufferedOutputStream bos = new BufferedOutputStream(baos);

			render.setProperty("output.format", "BMP"); //$NON-NLS-1$ //$NON-NLS-2$
			render.setProperty(IDeviceRenderer.FILE_IDENTIFIER, bos);

			gr.render(render, state);

			// Get image from stream.
			final ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
			final Image image = new Image(current, bais);
			final ImageData data = image.getImageData();
			clipboard.setContents(new Object[] { data }, new Transfer[] { ImageTransfer.getInstance() });
		} catch (final ChartException e) {
			e.printStackTrace();
		}
	}

	private Chart pimpChart(final double dpiFactor) {
		@SuppressWarnings("serial")
		final EcoreUtil.Copier copier = new EcoreUtil.Copier() {
			@Override
			public EObject copy(final EObject object) {
				final EObject copy = super.copy(object);
				if (copy instanceof LineAttributes) {
					final LineAttributes lineAttributes = (LineAttributes) copy;
					if (lineAttributes.isSetThickness()) {
						lineAttributes
								.setThickness((int) (lineAttributes.getThickness() / dpiFactor /*
																								 * "/ 2" who knows why?
																								 */));
					}
				}
				return copy;
			}
		};
		final Chart ret = (Chart) copier.copy(canvas.getChart());
		copier.copyReferences();
		return ret;
	}
}
