/*******************************************************************************
 * Basis-Plug-In fr die Darstellung von Charts mit BIRT
 * Copyright (C) 2009 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 ******************************************************************************/
package com.bitctrl.lib.eclipse.birt.chart.print;

import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

import com.bitctrl.lib.eclipse.paperclips.custom.CustomPrintHandler;

public class ChartPrintHandler implements CustomPrintHandler {
	private final Chart chart;
	private Device device;
	private int sizeX = 1;
	private int sizeY = 1;

	public ChartPrintHandler(final Chart chart) {
		this.chart = chart;
	}

	@Override
	public final void paint(final GC gc, final int x, final int y) {
		// initialize the SWT rendering device
		try {
			final PluginSettings ps = PluginSettings.instance();
			final IDeviceRenderer render = ps.getDevice("dv.SWT");
			render.setProperty(IDeviceRenderer.GRAPHICS_CONTEXT, gc);
			final Point dpi = gc.getDevice().getDPI();
			final Generator gr = Generator.instance();

			final double scaleX = 72.0 / dpi.x;
			final double scaleY = 72.0 / dpi.y;
			final GeneratedChartState state = gr.build(render.getDisplayServer(), pimpChart((scaleX + scaleY) / 2),
					BoundsImpl.create(x * scaleX, y * scaleY, sizeX * scaleX, sizeY * scaleY), null, null, null);

			gr.render(render, state);
		} catch (final ChartException ex) {
			ex.printStackTrace();
		}
	}

	private Chart pimpChart(final double dpiFactor) {
		@SuppressWarnings("serial")
		final EcoreUtil.Copier copier = new EcoreUtil.Copier() {
			@Override
			public EObject copy(final EObject object) {
				final EObject copy = super.copy(object);
				if (copy instanceof LineAttributes) {
					final LineAttributes lineAttributes = (LineAttributes) copy;
					if (lineAttributes.isSetThickness()) {
						lineAttributes.setThickness((int) (lineAttributes.getThickness() / dpiFactor));
					}
					// } else if (copy instanceof FontDefinition) {
					// FontDefinition fontDefinition = (FontDefinition) copy;
					// if (fontDefinition.isSetSize()) {
					// fontDefinition.setSize((float) (fontDefinition
					// .getSize() / dpiFactor));
					// }
				}

				return copy;
			}
		};
		final Chart ret = (Chart) copier.copy(chart);
		copier.copyReferences();
		return ret;
	}

	@Override
	public final Point getSize() {
		return new Point(sizeX, sizeY);
	}

	@Override
	public final void setSize(final int width, final int height) {
		sizeX = width;
		sizeY = height;
	}

	@Override
	public final void setDevice(final Device device) {
		this.device = device;
	}

	@Override
	public boolean isGreedyX() {
		return true;
	}

	@Override
	public boolean isGreedyY() {
		return true;
	}
}
