package com.bitctrl.lib.eclipse.databinding.converter;

import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;

public final class NullSafeConverter extends Converter {

	private final Object nullValue;
	private final IConverter wrapped;

	public NullSafeConverter(IConverter wrapped, Object nullValue) {
		super(wrapped.getFromType(), wrapped.getToType());
		this.wrapped = wrapped;
		this.nullValue = nullValue;
	}

	@Override
	public Object convert(final Object fromObject) {
		return null == fromObject ? nullValue : wrapped.convert(fromObject);
	}

}
