package com.bitctrl.lib.eclipse.databinding.converter;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.eclipse.core.databinding.conversion.Converter;

import com.bitctrl.util.Timestamp;

public class TimestampToStringConverter extends Converter {

	private final SimpleDateFormat formatter;
	private boolean date;
	private boolean time;
	private boolean relative;

	public TimestampToStringConverter(final String format) {
		super(Long.TYPE, String.class);
		formatter = new SimpleDateFormat(format);
	}

	public TimestampToStringConverter(final boolean date, final boolean time) {
		this(date, time, false);
	}

	public TimestampToStringConverter(final boolean date, final boolean time, final boolean relative) {
		super(Long.TYPE, String.class);
		formatter = null;
		this.date = date;
		this.time = time;
		this.relative = relative;
	}

	@Override
	public Object convert(final Object fromObject) {

		long timeValue = 0;
		if (fromObject instanceof Number) {
			timeValue = ((Number) fromObject).longValue();
		}

		if (formatter != null) {
			return formatter.format(new Date(timeValue));
		} else if (!relative) {
			return new Timestamp(timeValue).absoluteTime(date, time);
		} else {
			return new Timestamp(timeValue).relativeTime();
		}
	}
}
