package com.bitctrl.lib.eclipse.databinding.observables;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Widget;

/**
 * NON-API - An abstract superclass for observable values that guarantees that
 * the observable will be disposed when the control to which it is attached is
 * disposed.
 *
 * Copied from jface databinding.
 *
 * @since 1.1
 */
public abstract class AbstractSWTObservableValue extends AbstractObservableValue implements ISWTObservableValue {

	private final Widget widget;

	/**
	 * Standard constructor for an SWT ObservableValue. Makes sure that the
	 * observable gets disposed when the SWT widget is disposed.
	 *
	 * @param widget
	 */
	protected AbstractSWTObservableValue(Widget widget) {
		this(SWTObservables.getRealm(widget.getDisplay()), widget);
	}

	/**
	 * Constructor that allows for the setting of the realm. Makes sure that the
	 * observable gets disposed when the SWT widget is disposed.
	 *
	 * @param realm
	 * @param widget
	 * @since 1.2
	 */
	protected AbstractSWTObservableValue(Realm realm, Widget widget) {
		super(realm);
		this.widget = widget;
		widget.addDisposeListener(disposeListener);
	}

	private final DisposeListener disposeListener = new DisposeListener() {
		@Override
		public void widgetDisposed(DisposeEvent e) {
			AbstractSWTObservableValue.this.dispose();
		}
	};

	/**
	 * @return Returns the widget.
	 */
	@Override
	public Widget getWidget() {
		return widget;
	}

	private Object oldValue = null;

	protected void valueHasChanged() {
		final Object newValue = doGetValue();
		fireValueChange(Diffs.createValueDiff(oldValue, newValue));
		oldValue = newValue;
	}
}
