package com.bitctrl.lib.eclipse.databinding.observables;

import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

/**
 * The BusyIndicatorValue activates the {@link BusyIndicator} while performing
 * the {@link #setValue(Object)} operation on the wrapped
 * {@link IObservableValue} object.
 *
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 * @version $Id$
 */
public class BusyIndicatorValue extends ComputedValue {

	private final IObservableValue wrapped;

	public BusyIndicatorValue(final IObservableValue wrapped) {
		super(wrapped.getRealm(), wrapped.getValueType());
		this.wrapped = wrapped;
	}

	@Override
	protected Object calculate() {
		final Object[] ret = new Object[1];
		BusyIndicator.showWhile(Display.getDefault(), new Runnable() {
			@Override
			public void run() {
				ret[0] = wrapped.getValue();
			}
		});
		return ret[0];
	}

	@Override
	protected void doSetValue(final Object value) {
		BusyIndicator.showWhile(Display.getDefault(), new Runnable() {
			@Override
			public void run() {
				wrapped.setValue(value);
				wrapped.getValue();
			}
		});
	}
}
