/**
 *
 */
package com.bitctrl.lib.eclipse.databinding.observables;

import org.eclipse.core.databinding.observable.IObservableCollection;

/**
 * IObservableValue, das prft, ob ein bestimmter Wert in einer
 * IObservableCollection enthalten ist und gibt einen entspechend Boolean
 * zurck. nderungen an diesem Objekt werden auf die Collection angewendet.
 *
 * @author schnepel
 */
public final class CollectionContainsValue extends SilentComputedValue {
	private final IObservableCollection collection;
	private final Object object;

	public CollectionContainsValue(IObservableCollection collection, Object object) {
		super(collection.getRealm(), Boolean.TYPE, SilencePolicy.EqualsCall);
		this.collection = collection;
		this.object = object;
	}

	@Override
	protected Boolean calculate() {
		return collection.contains(object);
	}

	@Override
	protected void doSetValue(Object value) {
		if ((Boolean) value) {
			collection.add(object);
		} else {
			collection.remove(object);
		}
		getValue();
	}
}