package com.bitctrl.lib.eclipse.databinding.observables;

import java.util.Date;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

import com.bitctrl.lib.eclipse.widgets.DateTimeExtended;

public class DateTimeExtendedObservableValue extends AbstractSWTObservableValue {

	private final DateTimeExtended dt;
	private final SelectionListener listener;
	protected Date currentValue;
	protected boolean updating;

	/**
	 * @param dt
	 */
	public DateTimeExtendedObservableValue(final DateTimeExtended dt) {
		super(dt);
		this.dt = dt;
		currentValue = doGetValue();
		listener = new SelectionListener() {
			@Override
			public void widgetDefaultSelected(final SelectionEvent e) {
				widgetSelected(e);
			}

			@Override
			public void widgetSelected(final SelectionEvent e) {
				if (!updating) {
					final Date oldValue = currentValue;
					currentValue = doGetValue();
					fireValueChange(Diffs.createValueDiff(oldValue, currentValue));
				}
			}
		};
		dt.addSelectionListener(listener);
	}

	@Override
	public void doSetValue(final Object value) {
		final Date oldValue = doGetValue();
		try {
			updating = true;
			dt.setTimeInMillis((null == value ? new Date() : (Date) value).getTime());
			currentValue = doGetValue();
		} finally {
			updating = false;
		}
		fireValueChange(Diffs.createValueDiff(oldValue, currentValue));
	}

	@Override
	public Date doGetValue() {
		return new Date(dt.getTimeInMillis());
	}

	@Override
	public Object getValueType() {
		return Date.class;
	}
}
