package com.bitctrl.lib.eclipse.databinding.observables;

import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;

/**
 * Hilfsklasse zum Debugging von Observables.
 *
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 * @version $Id: $
 */
public class DebugObservables {
	/**
	 * Versteckter Konstruktor.
	 */
	private DebugObservables() {
	}

	/**
	 * Loggt nderungen am IObservableValue auf die Standardausgabe.
	 *
	 * @param prefix     der Prefix fr die Logmeldungen
	 * @param observable das Observable
	 */
	public static void logChanges(final String prefix, final IObservableValue observable) {
		observable.addValueChangeListener(new IValueChangeListener() {

			@Override
			public void handleValueChange(final ValueChangeEvent event) {
				System.out.println("[" + System.currentTimeMillis() + ":" + prefix + "] ValueChangeEvent");
				System.out.println(
						String.format("%-" + (prefix.length() + 2) + "s old value:%s", "", event.diff.getOldValue()));
				System.out.println(
						String.format("%-" + (prefix.length() + 2) + "s new value:%s", "", event.diff.getNewValue()));
				// final Exception exception = new Exception("Stacktrace");
				// exception.fillInStackTrace();
				// exception.printStackTrace();
			}
		});
	}

	/**
	 * Loggt nderungen an einer {@link IObservableList} auf die Standardausgabe.
	 *
	 * @param prefix         der Prefix fr die Logmeldungen
	 * @param observableList die observable Liste
	 */
	public static void logChanges(final String prefix, final IObservableList observableList) {
		observableList.addListChangeListener(new IListChangeListener() {

			@Override
			public void handleListChange(final ListChangeEvent event) {
				System.out.println("[" + System.currentTimeMillis() + ":" + prefix + "] ListChangeEvent");
				event.diff.accept(new ListDiffVisitor() {

					@Override
					public void handleRemove(final int index, final Object element) {
						System.out.println(String.format("%-" + (prefix.length() + 2) + "s index:%d remove %s", "",
								index, element.toString()));
					}

					@Override
					public void handleAdd(final int index, final Object element) {
						System.out.println(String.format("%-" + (prefix.length() + 2) + "s index:%d add    %s", "",
								index, element.toString()));
					}
				});
				// final Exception exception = new Exception("Stacktrace");
				// exception.fillInStackTrace();
				// exception.printStackTrace();
			}
		});
	}
}
