package com.bitctrl.lib.eclipse.databinding.observables;

import java.util.Set;

import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.set.ObservableSet;
import org.eclipse.core.databinding.observable.set.SetDiff;

public class ObservableMapKeySet extends ObservableSet {
	public ObservableMapKeySet(IObservableMap map) {
		super(map.getRealm(), map.keySet(), null);
		map.addMapChangeListener(new IMapChangeListener() {
			@Override
			public void handleMapChange(final MapChangeEvent event) {
				fireSetChange(new SetDiff() {
					@Override
					public Set getAdditions() {
						return event.diff.getAddedKeys();
					}

					@Override
					public Set getRemovals() {
						return event.diff.getRemovedKeys();
					}
				});
			}
		});
	}
}
