package com.bitctrl.lib.eclipse.databinding.observables;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;

/**
 * @author BitCtrl Systems GmbH, schnepel
 * @version $Id$
 */
public class ObservableSubSet extends WritableSet {
	private final class BigSetChangeListener implements ISetChangeListener {
		@Override
		public void handleSetChange(final SetChangeEvent event) {
			final List list = new ArrayList();
			for (final Object object : event.diff.getAdditions()) {
				final IObservableValue observableValue = createObservable(object);
				observableDetailMap.put(object, observableValue);
				if (isIncluded(observableValue)) {
					list.add(object);
				}
			}
			final Set removals = event.diff.getRemovals();
			for (final Object object : removals) {
				observableDetailMap.remove(object).dispose();
			}
			removeAll(removals);
			addAll(list);
		}
	}

	private final class SubSetChangeListener implements ISetChangeListener {
		@Override
		public void handleSetChange(final SetChangeEvent event) {
			for (final Object object : event.diff.getAdditions()) {
				IObservableValue observableValue = observableDetailMap.get(object);
				if (null == observableValue) {
					observableValue = createObservable(object);
					observableSet.add(object);
				}
				setIncluded(observableValue, true);
			}
			for (final Object object : event.diff.getRemovals()) {
				final IObservableValue observableValue = observableDetailMap.get(object);
				if (null != observableValue) {
					setIncluded(observableValue, false);
				}
			}
		}
	}

	private final class DetailValueChangeListener implements IValueChangeListener {
		@Override
		public void handleValueChange(final ValueChangeEvent event) {
			if (isIncluded(event.getObservableValue())) {
				add(event.getSource());
			} else {
				remove(event.getSource());
			}
		}
	}

	private final IObservableSet observableSet;
	private final Map<Object, IObservableValue> observableDetailMap = new HashMap<Object, IObservableValue>();
	private final IObservableFactory detailFactory;
	private final IValueChangeListener detailValueChangeListener = new DetailValueChangeListener();

	public ObservableSubSet(final IObservableSet observableSet, final IObservableFactory detailFactory) {
		super(observableSet.getRealm());
		this.observableSet = observableSet;
		this.detailFactory = detailFactory;
		final ISetChangeListener listener = new BigSetChangeListener();
		listener.handleSetChange(new SetChangeEvent(observableSet, Diffs.computeSetDiff(wrappedSet, observableSet)));
		addSetChangeListener(new SubSetChangeListener());
		this.observableSet.addSetChangeListener(listener);
	}

	private IObservableValue createObservable(final Object object) {
		final IObservableValue observableValue = (IObservableValue) detailFactory.createObservable(object);
		// handle detail value changes
		observableValue.addValueChangeListener(detailValueChangeListener);
		return observableValue;
	}

	@Override
	public synchronized void dispose() {
		super.dispose();
		observableSet.dispose();
	}

	protected boolean isIncluded(final IObservableValue object) {
		try {
			return (Boolean) object.getValue();
		} catch (final RuntimeException e) {
			return false;
		}
	}

	protected void setIncluded(final IObservableValue object, final boolean included) {
		try {
			object.setValue(included);
		} catch (final RuntimeException e) {
		}
	}
}
