/*
 * Rahmenwerk-Plug-in "Gangliniendarstellung"
 * Copyright (C) 2009 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package com.bitctrl.lib.eclipse.databinding.observables;

public enum SilencePolicy {
	/**
	 * Fires Events if the computed object doesn't equals via
	 * {@link Object#equals(Object)}.
	 */
	EqualsCall,

	/**
	 * Fires Events if the computed collection's content doesn't equals via ==.
	 * Applies only to {@link SilentComputedList}
	 */
	EqualsSignForContent,

	/**
	 * Fires Events if the computed object itself doesn't equals via ==.
	 */
	EqualsSign,

	/**
	 * Fires all events like the original computed objects
	 */
	FireAll
}
