package com.bitctrl.lib.eclipse.databinding.observables;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;

import com.bitctrl.util.Tupel;

public class SwitchDetailValue<F, T> extends ComputedValue {

	private final Map<F, Tupel<IObservableValue, IConverter>> map = new HashMap<F, Tupel<IObservableValue, IConverter>>();
	private final Tupel<IObservableValue, IConverter> def;
	private final IObservableValue master;

	public SwitchDetailValue(Class<F> f, Class<T> t, IObservableValue master, Object... list) {
		super(master.getRealm(), t);
		Assert.isTrue(master.getValueType().equals(f));
		this.master = master;

		IObservableValue def = null;
		for (int i = 0; i < list.length; i++) {
			final Object listVal = list[i];
			if (i + 1 < list.length) {
				i++;
				final Tupel<IObservableValue, IConverter> tupel = new Tupel<IObservableValue, IConverter>();
				final IObservableValue obs = makeObserverableValue(list[i]);
				tupel.setFirst(obs);
				if (i + 1 < list.length) {
					final Object conf = list[i + 1];
					if (conf instanceof IConverter) {
						i++;
						Assert.isTrue(obs.getValueType().equals(((IConverter) conf).getFromType()));
						Assert.isTrue(((IConverter) conf).getToType().equals(t));
						tupel.setSecond((IConverter) conf);
					} else {
						Assert.isTrue(obs.getValueType().equals(t));
					}
				} else {
					Assert.isTrue(obs.getValueType().equals(t));
				}
				map.put((F) listVal, tupel);
			} else {
				def = makeObserverableValue(listVal);
			}
		}
		this.def = new Tupel<IObservableValue, IConverter>(def, null);
		final T oldValue = (T) getValue();
	}

	private IObservableValue makeObserverableValue(Object o) {
		if (o instanceof IObservableValue) {
			return (IObservableValue) o;
		} else {
			return Observables.constantObservableValue(master.getRealm(), o, o.getClass());
		}
	}

	@Override
	protected T calculate() {
		final Tupel<IObservableValue, IConverter> t = getTupel();
		if (null == t.getSecond()) {
			return (T) t.getFirst().getValue();
		} else {
			return (T) t.getSecond().convert(t.getFirst().getValue());
		}
	}

	@Override
	public Object getValueType() {
		final Tupel<IObservableValue, IConverter> t = getTupel();
		if (null == t.getSecond()) {
			return t.getFirst().getValueType();
		} else {
			return t.getSecond().getToType();
		}
	}

	private Tupel<IObservableValue, IConverter> getTupel() {
		final Tupel<IObservableValue, IConverter> tupel = map.get(master.getValue());
		return null == tupel ? def : tupel;
	}
}
