package com.bitctrl.lib.eclipse.databinding.observables;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

/**
 * Observable value for an {@link org.eclipse.jface.action.Action#isChecked()
 * Action.isChecked()} state of an action configured as
 * {@link IAction#AS_CHECK_BOX toggleable}.
 *
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 * @version $Id: ToggleableActionObservableValue.java 26447 2010-09-29 14:28:59Z
 *          schnepel $
 */
public class ToggleableActionObservableValue extends AbstractObservableValue {

	private final IAction action;
	private final IPropertyChangeListener listener = new IPropertyChangeListener() {
		@Override
		public void propertyChange(final PropertyChangeEvent event) {
			if (IAction.CHECKED.equals(event.getProperty())) {
				fireValueChange(Diffs.createValueDiff(event.getOldValue(), event.getNewValue()));
			}
		}
	};

	public ToggleableActionObservableValue(final IAction action) {
		this.action = action;
		action.addPropertyChangeListener(listener);
	}

	@Override
	protected Object doGetValue() {
		return action.isChecked();
	}

	@Override
	public Object getValueType() {
		return Boolean.TYPE;
	}

	@Override
	protected void doSetValue(final Object value) {
		action.setChecked((Boolean) value);
	}

	@Override
	public synchronized void dispose() {
		action.removePropertyChangeListener(listener);
		super.dispose();
	}
}
