package com.bitctrl.lib.eclipse.databinding.provider;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;

public class ConvertingObservableMapLabelProvider extends ObservableMapLabelProvider {

	private final IConverter[] converters;
	private final IObservableMap[] attributeMaps;

	public ConvertingObservableMapLabelProvider(IObservableMap attributeMap, IConverter converter) {
		this(new IObservableMap[] { attributeMap }, new IConverter[] { converter });
	}

	public ConvertingObservableMapLabelProvider(IObservableMap[] attributeMaps, IConverter... converters) {
		super(attributeMaps);
		this.attributeMaps = attributeMaps;
		this.converters = converters;
	}

	@Override
	public String getColumnText(Object element, int columnIndex) {
		if (columnIndex < attributeMaps.length) {
			Object result = attributeMaps[columnIndex].get(element);
			IConverter converter = null;
			if (converters.length > columnIndex) {
				converter = converters[columnIndex];
			}
			if (null != converter) {
				result = converter.convert(result);
			}
			return result == null ? "" : result.toString(); //$NON-NLS-1$
		}
		return null;
	}

}
