/**
 * Rahmenwerk-Plug-in "Gangliniendarstellung fuer PuA-Protokolle"
 * Copyright (C) 2009 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package com.bitctrl.lib.eclipse.databinding.provider;

import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;

public class EnumIconDecorator extends DecoratingLabelProvider {

	public abstract static class IconLabelDecorator extends BaseLabelProvider implements ILabelDecorator {

		protected String getElementPartName(final Object element) {
			return element.getClass().isEnum() ? ((Enum<?>) element).name() : null;
		}

		@Override
		public Image decorateImage(final Image image, final Object element) {
			return decorateEnumImage(image, element.getClass().getSimpleName(), getElementPartName(element));
		}

		@Override
		public String decorateText(final String text, final Object element) {
			return decorateEnumText(text, element.getClass().getSimpleName(), getElementPartName(element));
		}

		protected abstract String decorateEnumText(final String text, final String simpleName,
				final String elementPartName);

		protected abstract Image decorateEnumImage(final Image image, final String enumBaseName,
				final String enumElementName);
	}

	public EnumIconDecorator(final ILabelProvider provider, final IconLabelDecorator decorator) {
		super(provider, decorator);
	}
}
