package com.bitctrl.lib.eclipse.databinding.provider;

import java.lang.reflect.Method;

import org.eclipse.jface.viewers.LabelProvider;

public class MessagesLabelProvider extends LabelProvider {

	private final String baseKey;
	private final Method getStringMethod;
	private final Object messages;

	public MessagesLabelProvider(final Class<?> messagesClass, final String baseKey)
			throws SecurityException, NoSuchMethodException {
		messages = null;
		this.baseKey = baseKey;
		getStringMethod = messagesClass.getDeclaredMethod("getString", String.class);
	}

	public MessagesLabelProvider(final Object messages, final String baseKey)
			throws SecurityException, NoSuchMethodException {
		this.messages = messages;
		this.baseKey = baseKey;
		getStringMethod = messages.getClass().getDeclaredMethod("getString", String.class);
	}

	@Override
	public String getText(final Object element) {
		final String key = getElementPartName(element);
		try {
			return (String) getStringMethod.invoke(messages, baseKey + key);
		} catch (final Exception e) {
			return "!" + key + "!";
		}
	}

	protected String getElementPartName(final Object element) {
		final String elementPart = element.getClass().isEnum() ? ((Enum<?>) element).name() : super.getText(element);
		return elementPart;
	}
}
