package com.bitctrl.lib.eclipse.databinding.validator;

import java.util.Collection;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/**
 * Validiert den Inhalt einer {@link Collection} mit eine Liste von
 * {@link IValidator Validatoren}.
 *
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 * @version $Id$
 */
public class CollectionValidator implements IValidator {

	private final Collection<?> collection;
	private final IValidator[] wrapped;

	public CollectionValidator(final Collection<?> collection, final IValidator... wrapped) {
		Assert.isNotNull(collection, "collection");
		Assert.isNotNull(wrapped, "wrapped");
		this.collection = collection;
		this.wrapped = wrapped;
	}

	@Override
	public IStatus validate(final Object value) {
		IStatus merged = Status.OK_STATUS;
		for (final Object element : collection) {
			merged = StatusUtils.mergeStatus(merged, element, wrapped);
		}
		return merged;
	}
}
