package com.bitctrl.lib.eclipse.databinding.validator;

import java.util.Date;

import org.eclipse.core.databinding.observable.value.IObservableValue;

/**
 * Validator, welcher ein Double-Objekt validiert.
 *
 * @author BitCtrl Systems GmbH, Andreas Meissner
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 * @version $Id$
 */
public class DateValidator extends RangeValidator<Date> {
	public DateValidator(final IntervallType intervall, final Date minValue, final Date maxValue,
			final boolean nullAllowed, final String errorText) {
		super(Date.class, intervall, minValue, maxValue, nullAllowed, errorText);
	}

	public DateValidator(final IntervallType intervall, final IObservableValue minValue,
			final IObservableValue maxValue, final boolean nullAllowed, final String errorText) {
		super(Date.class, intervall, minValue, maxValue, nullAllowed, errorText);
	}

	@Override
	protected double compare(final Date wertA, final Date wertB) {
		return wertA.compareTo(wertB);
	}
}
