package com.bitctrl.lib.eclipse.databinding.validator;

import org.eclipse.core.databinding.observable.value.IObservableValue;

/**
 * Validator, welcher ein Double-Objekt validiert.
 *
 * @author BitCtrl Systems GmbH, Andreas Meissner
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 * @version $Id$
 */
public class DoubleValidator extends RangeValidator<Double> {
	public DoubleValidator(final IntervallType intervall, final Double minValue, final Double maxValue,
			final boolean nullAllowed, final String errorText) {
		super(Double.class, intervall, minValue, maxValue, nullAllowed, errorText);
	}

	public DoubleValidator(final IntervallType intervall, final IObservableValue minValue,
			final IObservableValue maxValue, final boolean nullAllowed, final String errorText) {
		super(Double.class, intervall, minValue, maxValue, nullAllowed, errorText);
	}

	@Override
	protected double compare(final Double wertA, final Double wertB) {
		return wertA - wertB;
	}
}
