package com.bitctrl.lib.eclipse.databinding.validator;

import org.eclipse.core.databinding.observable.value.IObservableValue;

/**
 * Validator, welcher ein Integer-Objekt validiert.
 *
 * @author BitCtrl Systems GmbH, Andreas Meissner
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 * @version $Id$
 */
public class IntegerValidator extends RangeValidator<Integer> {
	public IntegerValidator(final IntervallType intervall, final Integer minValue, final Integer maxValue,
			final boolean nullAllowed, final String errorText) {
		super(Integer.class, intervall, minValue, maxValue, nullAllowed, errorText);
	}

	public IntegerValidator(final IntervallType intervall, final IObservableValue minValue,
			final IObservableValue maxValue, final boolean nullAllowed, final String errorText) {
		super(Integer.class, intervall, minValue, maxValue, nullAllowed, errorText);
	}

	@Override
	protected double compare(final Integer wertA, final Integer wertB) {
		return wertA - wertB;
	}
}
