package com.bitctrl.lib.eclipse.databinding.validator;

import org.eclipse.core.databinding.observable.value.IObservableValue;

/**
 * Validator, welcher ein Long-Objekt validiert.
 *
 * @author BitCtrl Systems GmbH, Andreas Meissner
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 * @version $Id$
 */
public class LongValidator extends RangeValidator<Long> {

	public LongValidator(final IntervallType intervall, final Long minValue, final Long maxValue,
			final boolean nullAllowed, final String errorText) {
		super(Long.class, intervall, minValue, maxValue, nullAllowed, errorText);
	}

	public LongValidator(final IntervallType intervall, final IObservableValue minValue,
			final IObservableValue maxValue, final boolean nullAllowed, final String errorText) {
		super(Long.class, intervall, minValue, maxValue, nullAllowed, errorText);
	}

	@Override
	protected double compare(final Long wertA, final Long wertB) {
		return wertA - wertB;
	}
}
